/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.b2bi.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteTransformer" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteTransformerRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Specifies the system-assigned unique identifier for the transformer.
     * </p>
     */
    private String transformerId;

    /**
     * <p>
     * Specifies the system-assigned unique identifier for the transformer.
     * </p>
     * 
     * @param transformerId
     *        Specifies the system-assigned unique identifier for the transformer.
     */

    public void setTransformerId(String transformerId) {
        this.transformerId = transformerId;
    }

    /**
     * <p>
     * Specifies the system-assigned unique identifier for the transformer.
     * </p>
     * 
     * @return Specifies the system-assigned unique identifier for the transformer.
     */

    public String getTransformerId() {
        return this.transformerId;
    }

    /**
     * <p>
     * Specifies the system-assigned unique identifier for the transformer.
     * </p>
     * 
     * @param transformerId
     *        Specifies the system-assigned unique identifier for the transformer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteTransformerRequest withTransformerId(String transformerId) {
        setTransformerId(transformerId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTransformerId() != null)
            sb.append("TransformerId: ").append(getTransformerId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteTransformerRequest == false)
            return false;
        DeleteTransformerRequest other = (DeleteTransformerRequest) obj;
        if (other.getTransformerId() == null ^ this.getTransformerId() == null)
            return false;
        if (other.getTransformerId() != null && other.getTransformerId().equals(this.getTransformerId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTransformerId() == null) ? 0 : getTransformerId().hashCode());
        return hashCode;
    }

    @Override
    public DeleteTransformerRequest clone() {
        return (DeleteTransformerRequest) super.clone();
    }

}
