/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscalingplans.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.autoscalingplans.model.CustomizedLoadMetricSpecification;
import com.amazonaws.services.autoscalingplans.model.PredefinedLoadMetricSpecification;
import com.amazonaws.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior;
import com.amazonaws.services.autoscalingplans.model.PredictiveScalingMode;
import com.amazonaws.services.autoscalingplans.model.ScalableDimension;
import com.amazonaws.services.autoscalingplans.model.ScalingPolicyUpdateBehavior;
import com.amazonaws.services.autoscalingplans.model.ServiceNamespace;
import com.amazonaws.services.autoscalingplans.model.TargetTrackingConfiguration;
import com.amazonaws.services.autoscalingplans.model.transform.ScalingInstructionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScalingInstruction
implements Serializable,
Cloneable,
StructuredPojo {
    private String serviceNamespace;
    private String resourceId;
    private String scalableDimension;
    private Integer minCapacity;
    private Integer maxCapacity;
    private List<TargetTrackingConfiguration> targetTrackingConfigurations;
    private PredefinedLoadMetricSpecification predefinedLoadMetricSpecification;
    private CustomizedLoadMetricSpecification customizedLoadMetricSpecification;
    private Integer scheduledActionBufferTime;
    private String predictiveScalingMaxCapacityBehavior;
    private Integer predictiveScalingMaxCapacityBuffer;
    private String predictiveScalingMode;
    private String scalingPolicyUpdateBehavior;
    private Boolean disableDynamicScaling;

    public void setServiceNamespace(String serviceNamespace) {
        this.serviceNamespace = serviceNamespace;
    }

    public String getServiceNamespace() {
        return this.serviceNamespace;
    }

    public ScalingInstruction withServiceNamespace(String serviceNamespace) {
        this.setServiceNamespace(serviceNamespace);
        return this;
    }

    public ScalingInstruction withServiceNamespace(ServiceNamespace serviceNamespace) {
        this.serviceNamespace = serviceNamespace.toString();
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ScalingInstruction withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setScalableDimension(String scalableDimension) {
        this.scalableDimension = scalableDimension;
    }

    public String getScalableDimension() {
        return this.scalableDimension;
    }

    public ScalingInstruction withScalableDimension(String scalableDimension) {
        this.setScalableDimension(scalableDimension);
        return this;
    }

    public ScalingInstruction withScalableDimension(ScalableDimension scalableDimension) {
        this.scalableDimension = scalableDimension.toString();
        return this;
    }

    public void setMinCapacity(Integer minCapacity) {
        this.minCapacity = minCapacity;
    }

    public Integer getMinCapacity() {
        return this.minCapacity;
    }

    public ScalingInstruction withMinCapacity(Integer minCapacity) {
        this.setMinCapacity(minCapacity);
        return this;
    }

    public void setMaxCapacity(Integer maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public Integer getMaxCapacity() {
        return this.maxCapacity;
    }

    public ScalingInstruction withMaxCapacity(Integer maxCapacity) {
        this.setMaxCapacity(maxCapacity);
        return this;
    }

    public List<TargetTrackingConfiguration> getTargetTrackingConfigurations() {
        return this.targetTrackingConfigurations;
    }

    public void setTargetTrackingConfigurations(Collection<TargetTrackingConfiguration> targetTrackingConfigurations) {
        if (targetTrackingConfigurations == null) {
            this.targetTrackingConfigurations = null;
            return;
        }
        this.targetTrackingConfigurations = new ArrayList<TargetTrackingConfiguration>(targetTrackingConfigurations);
    }

    public ScalingInstruction withTargetTrackingConfigurations(TargetTrackingConfiguration ... targetTrackingConfigurations) {
        if (this.targetTrackingConfigurations == null) {
            this.setTargetTrackingConfigurations(new ArrayList<TargetTrackingConfiguration>(targetTrackingConfigurations.length));
        }
        for (TargetTrackingConfiguration ele : targetTrackingConfigurations) {
            this.targetTrackingConfigurations.add(ele);
        }
        return this;
    }

    public ScalingInstruction withTargetTrackingConfigurations(Collection<TargetTrackingConfiguration> targetTrackingConfigurations) {
        this.setTargetTrackingConfigurations(targetTrackingConfigurations);
        return this;
    }

    public void setPredefinedLoadMetricSpecification(PredefinedLoadMetricSpecification predefinedLoadMetricSpecification) {
        this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
    }

    public PredefinedLoadMetricSpecification getPredefinedLoadMetricSpecification() {
        return this.predefinedLoadMetricSpecification;
    }

    public ScalingInstruction withPredefinedLoadMetricSpecification(PredefinedLoadMetricSpecification predefinedLoadMetricSpecification) {
        this.setPredefinedLoadMetricSpecification(predefinedLoadMetricSpecification);
        return this;
    }

    public void setCustomizedLoadMetricSpecification(CustomizedLoadMetricSpecification customizedLoadMetricSpecification) {
        this.customizedLoadMetricSpecification = customizedLoadMetricSpecification;
    }

    public CustomizedLoadMetricSpecification getCustomizedLoadMetricSpecification() {
        return this.customizedLoadMetricSpecification;
    }

    public ScalingInstruction withCustomizedLoadMetricSpecification(CustomizedLoadMetricSpecification customizedLoadMetricSpecification) {
        this.setCustomizedLoadMetricSpecification(customizedLoadMetricSpecification);
        return this;
    }

    public void setScheduledActionBufferTime(Integer scheduledActionBufferTime) {
        this.scheduledActionBufferTime = scheduledActionBufferTime;
    }

    public Integer getScheduledActionBufferTime() {
        return this.scheduledActionBufferTime;
    }

    public ScalingInstruction withScheduledActionBufferTime(Integer scheduledActionBufferTime) {
        this.setScheduledActionBufferTime(scheduledActionBufferTime);
        return this;
    }

    public void setPredictiveScalingMaxCapacityBehavior(String predictiveScalingMaxCapacityBehavior) {
        this.predictiveScalingMaxCapacityBehavior = predictiveScalingMaxCapacityBehavior;
    }

    public String getPredictiveScalingMaxCapacityBehavior() {
        return this.predictiveScalingMaxCapacityBehavior;
    }

    public ScalingInstruction withPredictiveScalingMaxCapacityBehavior(String predictiveScalingMaxCapacityBehavior) {
        this.setPredictiveScalingMaxCapacityBehavior(predictiveScalingMaxCapacityBehavior);
        return this;
    }

    public ScalingInstruction withPredictiveScalingMaxCapacityBehavior(PredictiveScalingMaxCapacityBehavior predictiveScalingMaxCapacityBehavior) {
        this.predictiveScalingMaxCapacityBehavior = predictiveScalingMaxCapacityBehavior.toString();
        return this;
    }

    public void setPredictiveScalingMaxCapacityBuffer(Integer predictiveScalingMaxCapacityBuffer) {
        this.predictiveScalingMaxCapacityBuffer = predictiveScalingMaxCapacityBuffer;
    }

    public Integer getPredictiveScalingMaxCapacityBuffer() {
        return this.predictiveScalingMaxCapacityBuffer;
    }

    public ScalingInstruction withPredictiveScalingMaxCapacityBuffer(Integer predictiveScalingMaxCapacityBuffer) {
        this.setPredictiveScalingMaxCapacityBuffer(predictiveScalingMaxCapacityBuffer);
        return this;
    }

    public void setPredictiveScalingMode(String predictiveScalingMode) {
        this.predictiveScalingMode = predictiveScalingMode;
    }

    public String getPredictiveScalingMode() {
        return this.predictiveScalingMode;
    }

    public ScalingInstruction withPredictiveScalingMode(String predictiveScalingMode) {
        this.setPredictiveScalingMode(predictiveScalingMode);
        return this;
    }

    public ScalingInstruction withPredictiveScalingMode(PredictiveScalingMode predictiveScalingMode) {
        this.predictiveScalingMode = predictiveScalingMode.toString();
        return this;
    }

    public void setScalingPolicyUpdateBehavior(String scalingPolicyUpdateBehavior) {
        this.scalingPolicyUpdateBehavior = scalingPolicyUpdateBehavior;
    }

    public String getScalingPolicyUpdateBehavior() {
        return this.scalingPolicyUpdateBehavior;
    }

    public ScalingInstruction withScalingPolicyUpdateBehavior(String scalingPolicyUpdateBehavior) {
        this.setScalingPolicyUpdateBehavior(scalingPolicyUpdateBehavior);
        return this;
    }

    public ScalingInstruction withScalingPolicyUpdateBehavior(ScalingPolicyUpdateBehavior scalingPolicyUpdateBehavior) {
        this.scalingPolicyUpdateBehavior = scalingPolicyUpdateBehavior.toString();
        return this;
    }

    public void setDisableDynamicScaling(Boolean disableDynamicScaling) {
        this.disableDynamicScaling = disableDynamicScaling;
    }

    public Boolean getDisableDynamicScaling() {
        return this.disableDynamicScaling;
    }

    public ScalingInstruction withDisableDynamicScaling(Boolean disableDynamicScaling) {
        this.setDisableDynamicScaling(disableDynamicScaling);
        return this;
    }

    public Boolean isDisableDynamicScaling() {
        return this.disableDynamicScaling;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceNamespace() != null) {
            sb.append("ServiceNamespace: ").append(this.getServiceNamespace()).append(",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getScalableDimension() != null) {
            sb.append("ScalableDimension: ").append(this.getScalableDimension()).append(",");
        }
        if (this.getMinCapacity() != null) {
            sb.append("MinCapacity: ").append(this.getMinCapacity()).append(",");
        }
        if (this.getMaxCapacity() != null) {
            sb.append("MaxCapacity: ").append(this.getMaxCapacity()).append(",");
        }
        if (this.getTargetTrackingConfigurations() != null) {
            sb.append("TargetTrackingConfigurations: ").append(this.getTargetTrackingConfigurations()).append(",");
        }
        if (this.getPredefinedLoadMetricSpecification() != null) {
            sb.append("PredefinedLoadMetricSpecification: ").append(this.getPredefinedLoadMetricSpecification()).append(",");
        }
        if (this.getCustomizedLoadMetricSpecification() != null) {
            sb.append("CustomizedLoadMetricSpecification: ").append(this.getCustomizedLoadMetricSpecification()).append(",");
        }
        if (this.getScheduledActionBufferTime() != null) {
            sb.append("ScheduledActionBufferTime: ").append(this.getScheduledActionBufferTime()).append(",");
        }
        if (this.getPredictiveScalingMaxCapacityBehavior() != null) {
            sb.append("PredictiveScalingMaxCapacityBehavior: ").append(this.getPredictiveScalingMaxCapacityBehavior()).append(",");
        }
        if (this.getPredictiveScalingMaxCapacityBuffer() != null) {
            sb.append("PredictiveScalingMaxCapacityBuffer: ").append(this.getPredictiveScalingMaxCapacityBuffer()).append(",");
        }
        if (this.getPredictiveScalingMode() != null) {
            sb.append("PredictiveScalingMode: ").append(this.getPredictiveScalingMode()).append(",");
        }
        if (this.getScalingPolicyUpdateBehavior() != null) {
            sb.append("ScalingPolicyUpdateBehavior: ").append(this.getScalingPolicyUpdateBehavior()).append(",");
        }
        if (this.getDisableDynamicScaling() != null) {
            sb.append("DisableDynamicScaling: ").append(this.getDisableDynamicScaling());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingInstruction)) {
            return false;
        }
        ScalingInstruction other = (ScalingInstruction)obj;
        if (other.getServiceNamespace() == null ^ this.getServiceNamespace() == null) {
            return false;
        }
        if (other.getServiceNamespace() != null && !other.getServiceNamespace().equals(this.getServiceNamespace())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getScalableDimension() == null ^ this.getScalableDimension() == null) {
            return false;
        }
        if (other.getScalableDimension() != null && !other.getScalableDimension().equals(this.getScalableDimension())) {
            return false;
        }
        if (other.getMinCapacity() == null ^ this.getMinCapacity() == null) {
            return false;
        }
        if (other.getMinCapacity() != null && !other.getMinCapacity().equals(this.getMinCapacity())) {
            return false;
        }
        if (other.getMaxCapacity() == null ^ this.getMaxCapacity() == null) {
            return false;
        }
        if (other.getMaxCapacity() != null && !other.getMaxCapacity().equals(this.getMaxCapacity())) {
            return false;
        }
        if (other.getTargetTrackingConfigurations() == null ^ this.getTargetTrackingConfigurations() == null) {
            return false;
        }
        if (other.getTargetTrackingConfigurations() != null && !other.getTargetTrackingConfigurations().equals(this.getTargetTrackingConfigurations())) {
            return false;
        }
        if (other.getPredefinedLoadMetricSpecification() == null ^ this.getPredefinedLoadMetricSpecification() == null) {
            return false;
        }
        if (other.getPredefinedLoadMetricSpecification() != null && !other.getPredefinedLoadMetricSpecification().equals(this.getPredefinedLoadMetricSpecification())) {
            return false;
        }
        if (other.getCustomizedLoadMetricSpecification() == null ^ this.getCustomizedLoadMetricSpecification() == null) {
            return false;
        }
        if (other.getCustomizedLoadMetricSpecification() != null && !other.getCustomizedLoadMetricSpecification().equals(this.getCustomizedLoadMetricSpecification())) {
            return false;
        }
        if (other.getScheduledActionBufferTime() == null ^ this.getScheduledActionBufferTime() == null) {
            return false;
        }
        if (other.getScheduledActionBufferTime() != null && !other.getScheduledActionBufferTime().equals(this.getScheduledActionBufferTime())) {
            return false;
        }
        if (other.getPredictiveScalingMaxCapacityBehavior() == null ^ this.getPredictiveScalingMaxCapacityBehavior() == null) {
            return false;
        }
        if (other.getPredictiveScalingMaxCapacityBehavior() != null && !other.getPredictiveScalingMaxCapacityBehavior().equals(this.getPredictiveScalingMaxCapacityBehavior())) {
            return false;
        }
        if (other.getPredictiveScalingMaxCapacityBuffer() == null ^ this.getPredictiveScalingMaxCapacityBuffer() == null) {
            return false;
        }
        if (other.getPredictiveScalingMaxCapacityBuffer() != null && !other.getPredictiveScalingMaxCapacityBuffer().equals(this.getPredictiveScalingMaxCapacityBuffer())) {
            return false;
        }
        if (other.getPredictiveScalingMode() == null ^ this.getPredictiveScalingMode() == null) {
            return false;
        }
        if (other.getPredictiveScalingMode() != null && !other.getPredictiveScalingMode().equals(this.getPredictiveScalingMode())) {
            return false;
        }
        if (other.getScalingPolicyUpdateBehavior() == null ^ this.getScalingPolicyUpdateBehavior() == null) {
            return false;
        }
        if (other.getScalingPolicyUpdateBehavior() != null && !other.getScalingPolicyUpdateBehavior().equals(this.getScalingPolicyUpdateBehavior())) {
            return false;
        }
        if (other.getDisableDynamicScaling() == null ^ this.getDisableDynamicScaling() == null) {
            return false;
        }
        return other.getDisableDynamicScaling() == null || other.getDisableDynamicScaling().equals(this.getDisableDynamicScaling());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceNamespace() == null ? 0 : this.getServiceNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getScalableDimension() == null ? 0 : this.getScalableDimension().hashCode());
        hashCode = 31 * hashCode + (this.getMinCapacity() == null ? 0 : this.getMinCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getMaxCapacity() == null ? 0 : this.getMaxCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getTargetTrackingConfigurations() == null ? 0 : this.getTargetTrackingConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getPredefinedLoadMetricSpecification() == null ? 0 : this.getPredefinedLoadMetricSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getCustomizedLoadMetricSpecification() == null ? 0 : this.getCustomizedLoadMetricSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getScheduledActionBufferTime() == null ? 0 : this.getScheduledActionBufferTime().hashCode());
        hashCode = 31 * hashCode + (this.getPredictiveScalingMaxCapacityBehavior() == null ? 0 : this.getPredictiveScalingMaxCapacityBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getPredictiveScalingMaxCapacityBuffer() == null ? 0 : this.getPredictiveScalingMaxCapacityBuffer().hashCode());
        hashCode = 31 * hashCode + (this.getPredictiveScalingMode() == null ? 0 : this.getPredictiveScalingMode().hashCode());
        hashCode = 31 * hashCode + (this.getScalingPolicyUpdateBehavior() == null ? 0 : this.getScalingPolicyUpdateBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getDisableDynamicScaling() == null ? 0 : this.getDisableDynamicScaling().hashCode());
        return hashCode;
    }

    public ScalingInstruction clone() {
        try {
            return (ScalingInstruction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalingInstructionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

