/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.Metric;
import com.amazonaws.services.autoscaling.model.MetricDimension;
import com.amazonaws.services.autoscaling.model.transform.MetricDimensionStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class MetricStaxUnmarshaller
implements Unmarshaller<Metric, StaxUnmarshallerContext> {
    private static MetricStaxUnmarshaller instance;

    public Metric unmarshall(StaxUnmarshallerContext context) throws Exception {
        Metric metric = new Metric();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return metric;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Namespace", targetDepth)) {
                    metric.setNamespace(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetricName", targetDepth)) {
                    metric.setMetricName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Dimensions", targetDepth)) {
                    metric.withDimensions(new ArrayList<MetricDimension>());
                    continue;
                }
                if (!context.testExpression("Dimensions/member", targetDepth)) continue;
                metric.withDimensions(MetricDimensionStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return metric;
    }

    public static MetricStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MetricStaxUnmarshaller();
        }
        return instance;
    }
}

