/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.LaunchTemplate;
import com.amazonaws.services.autoscaling.model.LaunchTemplateOverrides;
import com.amazonaws.services.autoscaling.model.transform.LaunchTemplateOverridesStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.LaunchTemplateSpecificationStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class LaunchTemplateStaxUnmarshaller
implements Unmarshaller<LaunchTemplate, StaxUnmarshallerContext> {
    private static LaunchTemplateStaxUnmarshaller instance;

    public LaunchTemplate unmarshall(StaxUnmarshallerContext context) throws Exception {
        LaunchTemplate launchTemplate = new LaunchTemplate();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return launchTemplate;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("LaunchTemplateSpecification", targetDepth)) {
                    launchTemplate.setLaunchTemplateSpecification(LaunchTemplateSpecificationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Overrides", targetDepth)) {
                    launchTemplate.withOverrides(new ArrayList<LaunchTemplateOverrides>());
                    continue;
                }
                if (!context.testExpression("Overrides/member", targetDepth)) continue;
                launchTemplate.withOverrides(LaunchTemplateOverridesStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return launchTemplate;
    }

    public static LaunchTemplateStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LaunchTemplateStaxUnmarshaller();
        }
        return instance;
    }
}

