/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.auditmanager.model.AssessmentStatus;
import com.amazonaws.services.auditmanager.model.Delegation;
import com.amazonaws.services.auditmanager.model.Role;
import com.amazonaws.services.auditmanager.model.transform.AssessmentMetadataItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AssessmentMetadataItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String id;
    private String complianceType;
    private String status;
    private List<Role> roles;
    private List<Delegation> delegations;
    private Date creationTime;
    private Date lastUpdated;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AssessmentMetadataItem withName(String name) {
        this.setName(name);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public AssessmentMetadataItem withId(String id) {
        this.setId(id);
        return this;
    }

    public void setComplianceType(String complianceType) {
        this.complianceType = complianceType;
    }

    public String getComplianceType() {
        return this.complianceType;
    }

    public AssessmentMetadataItem withComplianceType(String complianceType) {
        this.setComplianceType(complianceType);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public AssessmentMetadataItem withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public AssessmentMetadataItem withStatus(AssessmentStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Collection<Role> roles) {
        if (roles == null) {
            this.roles = null;
            return;
        }
        this.roles = new ArrayList<Role>(roles);
    }

    public AssessmentMetadataItem withRoles(Role ... roles) {
        if (this.roles == null) {
            this.setRoles(new ArrayList<Role>(roles.length));
        }
        for (Role ele : roles) {
            this.roles.add(ele);
        }
        return this;
    }

    public AssessmentMetadataItem withRoles(Collection<Role> roles) {
        this.setRoles(roles);
        return this;
    }

    public List<Delegation> getDelegations() {
        return this.delegations;
    }

    public void setDelegations(Collection<Delegation> delegations) {
        if (delegations == null) {
            this.delegations = null;
            return;
        }
        this.delegations = new ArrayList<Delegation>(delegations);
    }

    public AssessmentMetadataItem withDelegations(Delegation ... delegations) {
        if (this.delegations == null) {
            this.setDelegations(new ArrayList<Delegation>(delegations.length));
        }
        for (Delegation ele : delegations) {
            this.delegations.add(ele);
        }
        return this;
    }

    public AssessmentMetadataItem withDelegations(Collection<Delegation> delegations) {
        this.setDelegations(delegations);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public AssessmentMetadataItem withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public AssessmentMetadataItem withLastUpdated(Date lastUpdated) {
        this.setLastUpdated(lastUpdated);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getComplianceType() != null) {
            sb.append("ComplianceType: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getRoles() != null) {
            sb.append("Roles: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDelegations() != null) {
            sb.append("Delegations: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLastUpdated() != null) {
            sb.append("LastUpdated: ").append(this.getLastUpdated());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentMetadataItem)) {
            return false;
        }
        AssessmentMetadataItem other = (AssessmentMetadataItem)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getComplianceType() == null ^ this.getComplianceType() == null) {
            return false;
        }
        if (other.getComplianceType() != null && !other.getComplianceType().equals(this.getComplianceType())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getRoles() == null ^ this.getRoles() == null) {
            return false;
        }
        if (other.getRoles() != null && !other.getRoles().equals(this.getRoles())) {
            return false;
        }
        if (other.getDelegations() == null ^ this.getDelegations() == null) {
            return false;
        }
        if (other.getDelegations() != null && !other.getDelegations().equals(this.getDelegations())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastUpdated() == null ^ this.getLastUpdated() == null) {
            return false;
        }
        return other.getLastUpdated() == null || other.getLastUpdated().equals(this.getLastUpdated());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getComplianceType() == null ? 0 : this.getComplianceType().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getRoles() == null ? 0 : this.getRoles().hashCode());
        hashCode = 31 * hashCode + (this.getDelegations() == null ? 0 : this.getDelegations().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdated() == null ? 0 : this.getLastUpdated().hashCode());
        return hashCode;
    }

    public AssessmentMetadataItem clone() {
        try {
            return (AssessmentMetadataItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssessmentMetadataItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

