/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.auditmanager.model.CreateControlMappingSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateControlRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private String testingInformation;
    private String actionPlanTitle;
    private String actionPlanInstructions;
    private List<CreateControlMappingSource> controlMappingSources;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateControlRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateControlRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setTestingInformation(String testingInformation) {
        this.testingInformation = testingInformation;
    }

    public String getTestingInformation() {
        return this.testingInformation;
    }

    public CreateControlRequest withTestingInformation(String testingInformation) {
        this.setTestingInformation(testingInformation);
        return this;
    }

    public void setActionPlanTitle(String actionPlanTitle) {
        this.actionPlanTitle = actionPlanTitle;
    }

    public String getActionPlanTitle() {
        return this.actionPlanTitle;
    }

    public CreateControlRequest withActionPlanTitle(String actionPlanTitle) {
        this.setActionPlanTitle(actionPlanTitle);
        return this;
    }

    public void setActionPlanInstructions(String actionPlanInstructions) {
        this.actionPlanInstructions = actionPlanInstructions;
    }

    public String getActionPlanInstructions() {
        return this.actionPlanInstructions;
    }

    public CreateControlRequest withActionPlanInstructions(String actionPlanInstructions) {
        this.setActionPlanInstructions(actionPlanInstructions);
        return this;
    }

    public List<CreateControlMappingSource> getControlMappingSources() {
        return this.controlMappingSources;
    }

    public void setControlMappingSources(Collection<CreateControlMappingSource> controlMappingSources) {
        if (controlMappingSources == null) {
            this.controlMappingSources = null;
            return;
        }
        this.controlMappingSources = new ArrayList<CreateControlMappingSource>(controlMappingSources);
    }

    public CreateControlRequest withControlMappingSources(CreateControlMappingSource ... controlMappingSources) {
        if (this.controlMappingSources == null) {
            this.setControlMappingSources(new ArrayList<CreateControlMappingSource>(controlMappingSources.length));
        }
        for (CreateControlMappingSource ele : controlMappingSources) {
            this.controlMappingSources.add(ele);
        }
        return this;
    }

    public CreateControlRequest withControlMappingSources(Collection<CreateControlMappingSource> controlMappingSources) {
        this.setControlMappingSources(controlMappingSources);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateControlRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateControlRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateControlRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTestingInformation() != null) {
            sb.append("TestingInformation: ").append(this.getTestingInformation()).append(",");
        }
        if (this.getActionPlanTitle() != null) {
            sb.append("ActionPlanTitle: ").append(this.getActionPlanTitle()).append(",");
        }
        if (this.getActionPlanInstructions() != null) {
            sb.append("ActionPlanInstructions: ").append(this.getActionPlanInstructions()).append(",");
        }
        if (this.getControlMappingSources() != null) {
            sb.append("ControlMappingSources: ").append(this.getControlMappingSources()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateControlRequest)) {
            return false;
        }
        CreateControlRequest other = (CreateControlRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTestingInformation() == null ^ this.getTestingInformation() == null) {
            return false;
        }
        if (other.getTestingInformation() != null && !other.getTestingInformation().equals(this.getTestingInformation())) {
            return false;
        }
        if (other.getActionPlanTitle() == null ^ this.getActionPlanTitle() == null) {
            return false;
        }
        if (other.getActionPlanTitle() != null && !other.getActionPlanTitle().equals(this.getActionPlanTitle())) {
            return false;
        }
        if (other.getActionPlanInstructions() == null ^ this.getActionPlanInstructions() == null) {
            return false;
        }
        if (other.getActionPlanInstructions() != null && !other.getActionPlanInstructions().equals(this.getActionPlanInstructions())) {
            return false;
        }
        if (other.getControlMappingSources() == null ^ this.getControlMappingSources() == null) {
            return false;
        }
        if (other.getControlMappingSources() != null && !other.getControlMappingSources().equals(this.getControlMappingSources())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTestingInformation() == null ? 0 : this.getTestingInformation().hashCode());
        hashCode = 31 * hashCode + (this.getActionPlanTitle() == null ? 0 : this.getActionPlanTitle().hashCode());
        hashCode = 31 * hashCode + (this.getActionPlanInstructions() == null ? 0 : this.getActionPlanInstructions().hashCode());
        hashCode = 31 * hashCode + (this.getControlMappingSources() == null ? 0 : this.getControlMappingSources().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateControlRequest clone() {
        return (CreateControlRequest)super.clone();
    }
}

