/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.athena.model.PreparedStatementSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPreparedStatementsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<PreparedStatementSummary> preparedStatements;
    private String nextToken;

    public List<PreparedStatementSummary> getPreparedStatements() {
        return this.preparedStatements;
    }

    public void setPreparedStatements(Collection<PreparedStatementSummary> preparedStatements) {
        if (preparedStatements == null) {
            this.preparedStatements = null;
            return;
        }
        this.preparedStatements = new ArrayList<PreparedStatementSummary>(preparedStatements);
    }

    public ListPreparedStatementsResult withPreparedStatements(PreparedStatementSummary ... preparedStatements) {
        if (this.preparedStatements == null) {
            this.setPreparedStatements(new ArrayList<PreparedStatementSummary>(preparedStatements.length));
        }
        for (PreparedStatementSummary ele : preparedStatements) {
            this.preparedStatements.add(ele);
        }
        return this;
    }

    public ListPreparedStatementsResult withPreparedStatements(Collection<PreparedStatementSummary> preparedStatements) {
        this.setPreparedStatements(preparedStatements);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPreparedStatementsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPreparedStatements() != null) {
            sb.append("PreparedStatements: ").append(this.getPreparedStatements()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPreparedStatementsResult)) {
            return false;
        }
        ListPreparedStatementsResult other = (ListPreparedStatementsResult)obj;
        if (other.getPreparedStatements() == null ^ this.getPreparedStatements() == null) {
            return false;
        }
        if (other.getPreparedStatements() != null && !other.getPreparedStatements().equals(this.getPreparedStatements())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPreparedStatements() == null ? 0 : this.getPreparedStatements().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListPreparedStatementsResult clone() {
        try {
            return (ListPreparedStatementsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

