/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.athena.model.CalculationSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCalculationExecutionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<CalculationSummary> calculations;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCalculationExecutionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<CalculationSummary> getCalculations() {
        return this.calculations;
    }

    public void setCalculations(Collection<CalculationSummary> calculations) {
        if (calculations == null) {
            this.calculations = null;
            return;
        }
        this.calculations = new ArrayList<CalculationSummary>(calculations);
    }

    public ListCalculationExecutionsResult withCalculations(CalculationSummary ... calculations) {
        if (this.calculations == null) {
            this.setCalculations(new ArrayList<CalculationSummary>(calculations.length));
        }
        for (CalculationSummary ele : calculations) {
            this.calculations.add(ele);
        }
        return this;
    }

    public ListCalculationExecutionsResult withCalculations(Collection<CalculationSummary> calculations) {
        this.setCalculations(calculations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getCalculations() != null) {
            sb.append("Calculations: ").append(this.getCalculations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCalculationExecutionsResult)) {
            return false;
        }
        ListCalculationExecutionsResult other = (ListCalculationExecutionsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getCalculations() == null ^ this.getCalculations() == null) {
            return false;
        }
        return other.getCalculations() == null || other.getCalculations().equals(this.getCalculations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getCalculations() == null ? 0 : this.getCalculations().hashCode());
        return hashCode;
    }

    public ListCalculationExecutionsResult clone() {
        try {
            return (ListCalculationExecutionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

