/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.athena.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNotebookMetadata" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListNotebookMetadataRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Search filter string.
     * </p>
     */
    private FilterDefinition filters;
    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * Specifies the maximum number of results to return.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * The name of the Spark enabled workgroup to retrieve notebook metadata for.
     * </p>
     */
    private String workGroup;

    /**
     * <p>
     * Search filter string.
     * </p>
     * 
     * @param filters
     *        Search filter string.
     */

    public void setFilters(FilterDefinition filters) {
        this.filters = filters;
    }

    /**
     * <p>
     * Search filter string.
     * </p>
     * 
     * @return Search filter string.
     */

    public FilterDefinition getFilters() {
        return this.filters;
    }

    /**
     * <p>
     * Search filter string.
     * </p>
     * 
     * @param filters
     *        Search filter string.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNotebookMetadataRequest withFilters(FilterDefinition filters) {
        setFilters(filters);
        return this;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNotebookMetadataRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * Specifies the maximum number of results to return.
     * </p>
     * 
     * @param maxResults
     *        Specifies the maximum number of results to return.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * Specifies the maximum number of results to return.
     * </p>
     * 
     * @return Specifies the maximum number of results to return.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * Specifies the maximum number of results to return.
     * </p>
     * 
     * @param maxResults
     *        Specifies the maximum number of results to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNotebookMetadataRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * The name of the Spark enabled workgroup to retrieve notebook metadata for.
     * </p>
     * 
     * @param workGroup
     *        The name of the Spark enabled workgroup to retrieve notebook metadata for.
     */

    public void setWorkGroup(String workGroup) {
        this.workGroup = workGroup;
    }

    /**
     * <p>
     * The name of the Spark enabled workgroup to retrieve notebook metadata for.
     * </p>
     * 
     * @return The name of the Spark enabled workgroup to retrieve notebook metadata for.
     */

    public String getWorkGroup() {
        return this.workGroup;
    }

    /**
     * <p>
     * The name of the Spark enabled workgroup to retrieve notebook metadata for.
     * </p>
     * 
     * @param workGroup
     *        The name of the Spark enabled workgroup to retrieve notebook metadata for.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNotebookMetadataRequest withWorkGroup(String workGroup) {
        setWorkGroup(workGroup);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getFilters() != null)
            sb.append("Filters: ").append(getFilters()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getWorkGroup() != null)
            sb.append("WorkGroup: ").append(getWorkGroup());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListNotebookMetadataRequest == false)
            return false;
        ListNotebookMetadataRequest other = (ListNotebookMetadataRequest) obj;
        if (other.getFilters() == null ^ this.getFilters() == null)
            return false;
        if (other.getFilters() != null && other.getFilters().equals(this.getFilters()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getWorkGroup() == null ^ this.getWorkGroup() == null)
            return false;
        if (other.getWorkGroup() != null && other.getWorkGroup().equals(this.getWorkGroup()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getFilters() == null) ? 0 : getFilters().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getWorkGroup() == null) ? 0 : getWorkGroup().hashCode());
        return hashCode;
    }

    @Override
    public ListNotebookMetadataRequest clone() {
        return (ListNotebookMetadataRequest) super.clone();
    }

}
