/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.athena.model.SessionStatus;
import java.util.Date;

@SdkInternalApi
public class SessionStatusMarshaller {
    private static final MarshallingInfo<Date> STARTDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> IDLESINCEDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdleSinceDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> STATECHANGEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateChangeReason").build();
    private static final SessionStatusMarshaller instance = new SessionStatusMarshaller();

    public static SessionStatusMarshaller getInstance() {
        return instance;
    }

    public void marshall(SessionStatus sessionStatus, ProtocolMarshaller protocolMarshaller) {
        if (sessionStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sessionStatus.getStartDateTime(), STARTDATETIME_BINDING);
            protocolMarshaller.marshall((Object)sessionStatus.getLastModifiedDateTime(), LASTMODIFIEDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)sessionStatus.getEndDateTime(), ENDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)sessionStatus.getIdleSinceDateTime(), IDLESINCEDATETIME_BINDING);
            protocolMarshaller.marshall((Object)sessionStatus.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)sessionStatus.getStateChangeReason(), STATECHANGEREASON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

