/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model;

import com.amazonaws.services.apptest.model.AWSAppTestException;
import com.amazonaws.services.apptest.model.ValidationExceptionField;
import com.amazonaws.services.apptest.model.ValidationExceptionReason;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ValidationException
extends AWSAppTestException {
    private static final long serialVersionUID = 1L;
    private String reason;
    private List<ValidationExceptionField> fieldList;

    public ValidationException(String message) {
        super(message);
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    public ValidationException withReason(String reason) {
        this.setReason(reason);
        return this;
    }

    public ValidationException withReason(ValidationExceptionReason reason) {
        this.reason = reason.toString();
        return this;
    }

    @JsonProperty(value="fieldList")
    public List<ValidationExceptionField> getFieldList() {
        return this.fieldList;
    }

    @JsonProperty(value="fieldList")
    public void setFieldList(Collection<ValidationExceptionField> fieldList) {
        if (fieldList == null) {
            this.fieldList = null;
            return;
        }
        this.fieldList = new ArrayList<ValidationExceptionField>(fieldList);
    }

    public ValidationException withFieldList(ValidationExceptionField ... fieldList) {
        if (this.fieldList == null) {
            this.setFieldList(new ArrayList<ValidationExceptionField>(fieldList.length));
        }
        for (ValidationExceptionField ele : fieldList) {
            this.fieldList.add(ele);
        }
        return this;
    }

    public ValidationException withFieldList(Collection<ValidationExceptionField> fieldList) {
        this.setFieldList(fieldList);
        return this;
    }
}

