/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apptest.model.InputFile;

@SdkInternalApi
public class InputFileMarshaller {
    private static final MarshallingInfo<String> SOURCELOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceLocation").build();
    private static final MarshallingInfo<String> TARGETLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetLocation").build();
    private static final MarshallingInfo<StructuredPojo> FILEMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileMetadata").build();
    private static final InputFileMarshaller instance = new InputFileMarshaller();

    public static InputFileMarshaller getInstance() {
        return instance;
    }

    public void marshall(InputFile inputFile, ProtocolMarshaller protocolMarshaller) {
        if (inputFile == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputFile.getSourceLocation(), SOURCELOCATION_BINDING);
            protocolMarshaller.marshall((Object)inputFile.getTargetLocation(), TARGETLOCATION_BINDING);
            protocolMarshaller.marshall((Object)inputFile.getFileMetadata(), FILEMETADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

