/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appsync.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypesByAssociation" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListTypesByAssociationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs
     * (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in
     * other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * </p>
     */
    private String mergedApiIdentifier;
    /**
     * <p>
     * The ID generated by the AppSync service for the source API association.
     * </p>
     */
    private String associationId;
    /**
     * <p>
     * The format type.
     * </p>
     */
    private String format;
    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which you can use to return the next
     * set of items in the list.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The maximum number of results that you want the request to return.
     * </p>
     */
    private Integer maxResults;

    /**
     * <p>
     * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs
     * (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in
     * other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * </p>
     * 
     * @param mergedApiIdentifier
     *        The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged
     *        APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged
     *        APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     */

    public void setMergedApiIdentifier(String mergedApiIdentifier) {
        this.mergedApiIdentifier = mergedApiIdentifier;
    }

    /**
     * <p>
     * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs
     * (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in
     * other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * </p>
     * 
     * @return The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged
     *         APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged
     *         APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged
     *         API.
     */

    public String getMergedApiIdentifier() {
        return this.mergedApiIdentifier;
    }

    /**
     * <p>
     * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs
     * (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in
     * other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * </p>
     * 
     * @param mergedApiIdentifier
     *        The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged
     *        APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged
     *        APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTypesByAssociationRequest withMergedApiIdentifier(String mergedApiIdentifier) {
        setMergedApiIdentifier(mergedApiIdentifier);
        return this;
    }

    /**
     * <p>
     * The ID generated by the AppSync service for the source API association.
     * </p>
     * 
     * @param associationId
     *        The ID generated by the AppSync service for the source API association.
     */

    public void setAssociationId(String associationId) {
        this.associationId = associationId;
    }

    /**
     * <p>
     * The ID generated by the AppSync service for the source API association.
     * </p>
     * 
     * @return The ID generated by the AppSync service for the source API association.
     */

    public String getAssociationId() {
        return this.associationId;
    }

    /**
     * <p>
     * The ID generated by the AppSync service for the source API association.
     * </p>
     * 
     * @param associationId
     *        The ID generated by the AppSync service for the source API association.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTypesByAssociationRequest withAssociationId(String associationId) {
        setAssociationId(associationId);
        return this;
    }

    /**
     * <p>
     * The format type.
     * </p>
     * 
     * @param format
     *        The format type.
     * @see TypeDefinitionFormat
     */

    public void setFormat(String format) {
        this.format = format;
    }

    /**
     * <p>
     * The format type.
     * </p>
     * 
     * @return The format type.
     * @see TypeDefinitionFormat
     */

    public String getFormat() {
        return this.format;
    }

    /**
     * <p>
     * The format type.
     * </p>
     * 
     * @param format
     *        The format type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TypeDefinitionFormat
     */

    public ListTypesByAssociationRequest withFormat(String format) {
        setFormat(format);
        return this;
    }

    /**
     * <p>
     * The format type.
     * </p>
     * 
     * @param format
     *        The format type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TypeDefinitionFormat
     */

    public ListTypesByAssociationRequest withFormat(TypeDefinitionFormat format) {
        this.format = format.toString();
        return this;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which you can use to return the next
     * set of items in the list.
     * </p>
     * 
     * @param nextToken
     *        An identifier that was returned from the previous call to this operation, which you can use to return the
     *        next set of items in the list.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which you can use to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which you can use to return the
     *         next set of items in the list.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which you can use to return the next
     * set of items in the list.
     * </p>
     * 
     * @param nextToken
     *        An identifier that was returned from the previous call to this operation, which you can use to return the
     *        next set of items in the list.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTypesByAssociationRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The maximum number of results that you want the request to return.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results that you want the request to return.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results that you want the request to return.
     * </p>
     * 
     * @return The maximum number of results that you want the request to return.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results that you want the request to return.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results that you want the request to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTypesByAssociationRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMergedApiIdentifier() != null)
            sb.append("MergedApiIdentifier: ").append(getMergedApiIdentifier()).append(",");
        if (getAssociationId() != null)
            sb.append("AssociationId: ").append(getAssociationId()).append(",");
        if (getFormat() != null)
            sb.append("Format: ").append(getFormat()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListTypesByAssociationRequest == false)
            return false;
        ListTypesByAssociationRequest other = (ListTypesByAssociationRequest) obj;
        if (other.getMergedApiIdentifier() == null ^ this.getMergedApiIdentifier() == null)
            return false;
        if (other.getMergedApiIdentifier() != null && other.getMergedApiIdentifier().equals(this.getMergedApiIdentifier()) == false)
            return false;
        if (other.getAssociationId() == null ^ this.getAssociationId() == null)
            return false;
        if (other.getAssociationId() != null && other.getAssociationId().equals(this.getAssociationId()) == false)
            return false;
        if (other.getFormat() == null ^ this.getFormat() == null)
            return false;
        if (other.getFormat() != null && other.getFormat().equals(this.getFormat()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMergedApiIdentifier() == null) ? 0 : getMergedApiIdentifier().hashCode());
        hashCode = prime * hashCode + ((getAssociationId() == null) ? 0 : getAssociationId().hashCode());
        hashCode = prime * hashCode + ((getFormat() == null) ? 0 : getFormat().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public ListTypesByAssociationRequest clone() {
        return (ListTypesByAssociationRequest) super.clone();
    }

}
