/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appsync.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appsync.model.DataSourceIntrospectionModel;
import com.amazonaws.services.appsync.model.transform.DataSourceIntrospectionResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataSourceIntrospectionResult
implements Serializable,
Cloneable,
StructuredPojo {
    private List<DataSourceIntrospectionModel> models;
    private String nextToken;

    public List<DataSourceIntrospectionModel> getModels() {
        return this.models;
    }

    public void setModels(Collection<DataSourceIntrospectionModel> models) {
        if (models == null) {
            this.models = null;
            return;
        }
        this.models = new ArrayList<DataSourceIntrospectionModel>(models);
    }

    public DataSourceIntrospectionResult withModels(DataSourceIntrospectionModel ... models) {
        if (this.models == null) {
            this.setModels(new ArrayList<DataSourceIntrospectionModel>(models.length));
        }
        for (DataSourceIntrospectionModel ele : models) {
            this.models.add(ele);
        }
        return this;
    }

    public DataSourceIntrospectionResult withModels(Collection<DataSourceIntrospectionModel> models) {
        this.setModels(models);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DataSourceIntrospectionResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModels() != null) {
            sb.append("Models: ").append(this.getModels()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceIntrospectionResult)) {
            return false;
        }
        DataSourceIntrospectionResult other = (DataSourceIntrospectionResult)obj;
        if (other.getModels() == null ^ this.getModels() == null) {
            return false;
        }
        if (other.getModels() != null && !other.getModels().equals(this.getModels())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModels() == null ? 0 : this.getModels().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DataSourceIntrospectionResult clone() {
        try {
            return (DataSourceIntrospectionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataSourceIntrospectionResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

