/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appsync.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes a GraphQL API.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GraphqlApi" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GraphqlApi implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The API name.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The API ID.
     * </p>
     */
    private String apiId;
    /**
     * <p>
     * The authentication type.
     * </p>
     */
    private String authenticationType;
    /**
     * <p>
     * The Amazon Cognito User Pool configuration.
     * </p>
     */
    private UserPoolConfig userPoolConfig;
    /**
     * <p>
     * The ARN.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * The URIs.
     * </p>
     */
    private java.util.Map<String, String> uris;

    /**
     * <p>
     * The API name.
     * </p>
     * 
     * @param name
     *        The API name.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The API name.
     * </p>
     * 
     * @return The API name.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The API name.
     * </p>
     * 
     * @param name
     *        The API name.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GraphqlApi withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The API ID.
     * </p>
     * 
     * @param apiId
     *        The API ID.
     */

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    /**
     * <p>
     * The API ID.
     * </p>
     * 
     * @return The API ID.
     */

    public String getApiId() {
        return this.apiId;
    }

    /**
     * <p>
     * The API ID.
     * </p>
     * 
     * @param apiId
     *        The API ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GraphqlApi withApiId(String apiId) {
        setApiId(apiId);
        return this;
    }

    /**
     * <p>
     * The authentication type.
     * </p>
     * 
     * @param authenticationType
     *        The authentication type.
     * @see AuthenticationType
     */

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    /**
     * <p>
     * The authentication type.
     * </p>
     * 
     * @return The authentication type.
     * @see AuthenticationType
     */

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    /**
     * <p>
     * The authentication type.
     * </p>
     * 
     * @param authenticationType
     *        The authentication type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AuthenticationType
     */

    public GraphqlApi withAuthenticationType(String authenticationType) {
        setAuthenticationType(authenticationType);
        return this;
    }

    /**
     * <p>
     * The authentication type.
     * </p>
     * 
     * @param authenticationType
     *        The authentication type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AuthenticationType
     */

    public GraphqlApi withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType.toString();
        return this;
    }

    /**
     * <p>
     * The Amazon Cognito User Pool configuration.
     * </p>
     * 
     * @param userPoolConfig
     *        The Amazon Cognito User Pool configuration.
     */

    public void setUserPoolConfig(UserPoolConfig userPoolConfig) {
        this.userPoolConfig = userPoolConfig;
    }

    /**
     * <p>
     * The Amazon Cognito User Pool configuration.
     * </p>
     * 
     * @return The Amazon Cognito User Pool configuration.
     */

    public UserPoolConfig getUserPoolConfig() {
        return this.userPoolConfig;
    }

    /**
     * <p>
     * The Amazon Cognito User Pool configuration.
     * </p>
     * 
     * @param userPoolConfig
     *        The Amazon Cognito User Pool configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GraphqlApi withUserPoolConfig(UserPoolConfig userPoolConfig) {
        setUserPoolConfig(userPoolConfig);
        return this;
    }

    /**
     * <p>
     * The ARN.
     * </p>
     * 
     * @param arn
     *        The ARN.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * The ARN.
     * </p>
     * 
     * @return The ARN.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * The ARN.
     * </p>
     * 
     * @param arn
     *        The ARN.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GraphqlApi withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * The URIs.
     * </p>
     * 
     * @return The URIs.
     */

    public java.util.Map<String, String> getUris() {
        return uris;
    }

    /**
     * <p>
     * The URIs.
     * </p>
     * 
     * @param uris
     *        The URIs.
     */

    public void setUris(java.util.Map<String, String> uris) {
        this.uris = uris;
    }

    /**
     * <p>
     * The URIs.
     * </p>
     * 
     * @param uris
     *        The URIs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GraphqlApi withUris(java.util.Map<String, String> uris) {
        setUris(uris);
        return this;
    }

    public GraphqlApi addUrisEntry(String key, String value) {
        if (null == this.uris) {
            this.uris = new java.util.HashMap<String, String>();
        }
        if (this.uris.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.uris.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Uris.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GraphqlApi clearUrisEntries() {
        this.uris = null;
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getApiId() != null)
            sb.append("ApiId: ").append(getApiId()).append(",");
        if (getAuthenticationType() != null)
            sb.append("AuthenticationType: ").append(getAuthenticationType()).append(",");
        if (getUserPoolConfig() != null)
            sb.append("UserPoolConfig: ").append(getUserPoolConfig()).append(",");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getUris() != null)
            sb.append("Uris: ").append(getUris());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GraphqlApi == false)
            return false;
        GraphqlApi other = (GraphqlApi) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getApiId() == null ^ this.getApiId() == null)
            return false;
        if (other.getApiId() != null && other.getApiId().equals(this.getApiId()) == false)
            return false;
        if (other.getAuthenticationType() == null ^ this.getAuthenticationType() == null)
            return false;
        if (other.getAuthenticationType() != null && other.getAuthenticationType().equals(this.getAuthenticationType()) == false)
            return false;
        if (other.getUserPoolConfig() == null ^ this.getUserPoolConfig() == null)
            return false;
        if (other.getUserPoolConfig() != null && other.getUserPoolConfig().equals(this.getUserPoolConfig()) == false)
            return false;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getUris() == null ^ this.getUris() == null)
            return false;
        if (other.getUris() != null && other.getUris().equals(this.getUris()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getApiId() == null) ? 0 : getApiId().hashCode());
        hashCode = prime * hashCode + ((getAuthenticationType() == null) ? 0 : getAuthenticationType().hashCode());
        hashCode = prime * hashCode + ((getUserPoolConfig() == null) ? 0 : getUserPoolConfig().hashCode());
        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getUris() == null) ? 0 : getUris().hashCode());
        return hashCode;
    }

    @Override
    public GraphqlApi clone() {
        try {
            return (GraphqlApi) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.appsync.model.transform.GraphqlApiMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
