/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.appstream.model.VpcConfig;
import java.util.List;

public class VpcConfigJsonMarshaller {
    private static VpcConfigJsonMarshaller instance;

    public void marshall(VpcConfig vpcConfig, StructuredJsonGenerator jsonGenerator) {
        if (vpcConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            List<String> subnetIdsList = vpcConfig.getSubnetIds();
            if (subnetIdsList != null) {
                jsonGenerator.writeFieldName("SubnetIds");
                jsonGenerator.writeStartArray();
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue == null) continue;
                    jsonGenerator.writeValue(subnetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VpcConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VpcConfigJsonMarshaller();
        }
        return instance;
    }
}

