/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.appstream.model.Application;
import com.amazonaws.services.appstream.model.Image;
import com.amazonaws.services.appstream.model.transform.ApplicationJsonMarshaller;
import com.amazonaws.services.appstream.model.transform.ImageStateChangeReasonJsonMarshaller;
import java.util.List;

public class ImageJsonMarshaller {
    private static ImageJsonMarshaller instance;

    public void marshall(Image image, StructuredJsonGenerator jsonGenerator) {
        if (image == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Application> applicationsList;
            jsonGenerator.writeStartObject();
            if (image.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(image.getName());
            }
            if (image.getArn() != null) {
                jsonGenerator.writeFieldName("Arn").writeValue(image.getArn());
            }
            if (image.getBaseImageArn() != null) {
                jsonGenerator.writeFieldName("BaseImageArn").writeValue(image.getBaseImageArn());
            }
            if (image.getDisplayName() != null) {
                jsonGenerator.writeFieldName("DisplayName").writeValue(image.getDisplayName());
            }
            if (image.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(image.getState());
            }
            if (image.getVisibility() != null) {
                jsonGenerator.writeFieldName("Visibility").writeValue(image.getVisibility());
            }
            if (image.getPlatform() != null) {
                jsonGenerator.writeFieldName("Platform").writeValue(image.getPlatform());
            }
            if (image.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(image.getDescription());
            }
            if (image.getStateChangeReason() != null) {
                jsonGenerator.writeFieldName("StateChangeReason");
                ImageStateChangeReasonJsonMarshaller.getInstance().marshall(image.getStateChangeReason(), jsonGenerator);
            }
            if ((applicationsList = image.getApplications()) != null) {
                jsonGenerator.writeFieldName("Applications");
                jsonGenerator.writeStartArray();
                for (Application applicationsListValue : applicationsList) {
                    if (applicationsListValue == null) continue;
                    ApplicationJsonMarshaller.getInstance().marshall(applicationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (image.getCreatedTime() != null) {
                jsonGenerator.writeFieldName("CreatedTime").writeValue(image.getCreatedTime());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ImageJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ImageJsonMarshaller();
        }
        return instance;
    }
}

