/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.appstream.model.CreateFleetRequest;
import com.amazonaws.services.appstream.model.transform.ComputeCapacityJsonMarshaller;
import com.amazonaws.services.appstream.model.transform.VpcConfigJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateFleetRequestMarshaller
implements Marshaller<Request<CreateFleetRequest>, CreateFleetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateFleetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateFleetRequest> marshall(CreateFleetRequest createFleetRequest) {
        if (createFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createFleetRequest, "AmazonAppStream");
        request.addHeader("X-Amz-Target", "PhotonAdminProxyService.CreateFleet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createFleetRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createFleetRequest.getName());
            }
            if (createFleetRequest.getImageName() != null) {
                jsonGenerator.writeFieldName("ImageName").writeValue(createFleetRequest.getImageName());
            }
            if (createFleetRequest.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(createFleetRequest.getInstanceType());
            }
            if (createFleetRequest.getComputeCapacity() != null) {
                jsonGenerator.writeFieldName("ComputeCapacity");
                ComputeCapacityJsonMarshaller.getInstance().marshall(createFleetRequest.getComputeCapacity(), jsonGenerator);
            }
            if (createFleetRequest.getVpcConfig() != null) {
                jsonGenerator.writeFieldName("VpcConfig");
                VpcConfigJsonMarshaller.getInstance().marshall(createFleetRequest.getVpcConfig(), jsonGenerator);
            }
            if (createFleetRequest.getMaxUserDurationInSeconds() != null) {
                jsonGenerator.writeFieldName("MaxUserDurationInSeconds").writeValue(createFleetRequest.getMaxUserDurationInSeconds().intValue());
            }
            if (createFleetRequest.getDisconnectTimeoutInSeconds() != null) {
                jsonGenerator.writeFieldName("DisconnectTimeoutInSeconds").writeValue(createFleetRequest.getDisconnectTimeoutInSeconds().intValue());
            }
            if (createFleetRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createFleetRequest.getDescription());
            }
            if (createFleetRequest.getDisplayName() != null) {
                jsonGenerator.writeFieldName("DisplayName").writeValue(createFleetRequest.getDisplayName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

