/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apprunner.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apprunner.model.transform.ImageConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ImageConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> runtimeEnvironmentVariables;
    private String startCommand;
    private String port;

    public Map<String, String> getRuntimeEnvironmentVariables() {
        return this.runtimeEnvironmentVariables;
    }

    public void setRuntimeEnvironmentVariables(Map<String, String> runtimeEnvironmentVariables) {
        this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
    }

    public ImageConfiguration withRuntimeEnvironmentVariables(Map<String, String> runtimeEnvironmentVariables) {
        this.setRuntimeEnvironmentVariables(runtimeEnvironmentVariables);
        return this;
    }

    public ImageConfiguration addRuntimeEnvironmentVariablesEntry(String key, String value) {
        if (null == this.runtimeEnvironmentVariables) {
            this.runtimeEnvironmentVariables = new HashMap<String, String>();
        }
        if (this.runtimeEnvironmentVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.runtimeEnvironmentVariables.put(key, value);
        return this;
    }

    public ImageConfiguration clearRuntimeEnvironmentVariablesEntries() {
        this.runtimeEnvironmentVariables = null;
        return this;
    }

    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public ImageConfiguration withStartCommand(String startCommand) {
        this.setStartCommand(startCommand);
        return this;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPort() {
        return this.port;
    }

    public ImageConfiguration withPort(String port) {
        this.setPort(port);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuntimeEnvironmentVariables() != null) {
            sb.append("RuntimeEnvironmentVariables: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getStartCommand() != null) {
            sb.append("StartCommand: ").append(this.getStartCommand()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageConfiguration)) {
            return false;
        }
        ImageConfiguration other = (ImageConfiguration)obj;
        if (other.getRuntimeEnvironmentVariables() == null ^ this.getRuntimeEnvironmentVariables() == null) {
            return false;
        }
        if (other.getRuntimeEnvironmentVariables() != null && !other.getRuntimeEnvironmentVariables().equals(this.getRuntimeEnvironmentVariables())) {
            return false;
        }
        if (other.getStartCommand() == null ^ this.getStartCommand() == null) {
            return false;
        }
        if (other.getStartCommand() != null && !other.getStartCommand().equals(this.getStartCommand())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        return other.getPort() == null || other.getPort().equals(this.getPort());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuntimeEnvironmentVariables() == null ? 0 : this.getRuntimeEnvironmentVariables().hashCode());
        hashCode = 31 * hashCode + (this.getStartCommand() == null ? 0 : this.getStartCommand().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        return hashCode;
    }

    public ImageConfiguration clone() {
        try {
            return (ImageConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

