/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appregistry;

import javax.annotation.Generated;

import com.amazonaws.services.appregistry.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSAppRegistry}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAppRegistry implements AWSAppRegistry {

    protected AbstractAWSAppRegistry() {
    }

    @Override
    public AssociateAttributeGroupResult associateAttributeGroup(AssociateAttributeGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateResourceResult associateResource(AssociateResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAttributeGroupResult createAttributeGroup(CreateAttributeGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApplicationResult deleteApplication(DeleteApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAttributeGroupResult deleteAttributeGroup(DeleteAttributeGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateAttributeGroupResult disassociateAttributeGroup(DisassociateAttributeGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateResourceResult disassociateResource(DisassociateResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApplicationResult getApplication(GetApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssociatedResourceResult getAssociatedResource(GetAssociatedResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAttributeGroupResult getAttributeGroup(GetAttributeGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConfigurationResult getConfiguration(GetConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationsResult listApplications(ListApplicationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssociatedAttributeGroupsResult listAssociatedAttributeGroups(ListAssociatedAttributeGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssociatedResourcesResult listAssociatedResources(ListAssociatedResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAttributeGroupsResult listAttributeGroups(ListAttributeGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAttributeGroupsForApplicationResult listAttributeGroupsForApplication(ListAttributeGroupsForApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutConfigurationResult putConfiguration(PutConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SyncResourceResult syncResource(SyncResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApplicationResult updateApplication(UpdateApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAttributeGroupResult updateAttributeGroup(UpdateAttributeGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
