/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appmesh.model.DnsResponseType;
import com.amazonaws.services.appmesh.model.IpPreference;
import com.amazonaws.services.appmesh.model.transform.DnsServiceDiscoveryMarshaller;
import java.io.Serializable;

public class DnsServiceDiscovery
implements Serializable,
Cloneable,
StructuredPojo {
    private String hostname;
    private String ipPreference;
    private String responseType;

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public DnsServiceDiscovery withHostname(String hostname) {
        this.setHostname(hostname);
        return this;
    }

    public void setIpPreference(String ipPreference) {
        this.ipPreference = ipPreference;
    }

    public String getIpPreference() {
        return this.ipPreference;
    }

    public DnsServiceDiscovery withIpPreference(String ipPreference) {
        this.setIpPreference(ipPreference);
        return this;
    }

    public DnsServiceDiscovery withIpPreference(IpPreference ipPreference) {
        this.ipPreference = ipPreference.toString();
        return this;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public DnsServiceDiscovery withResponseType(String responseType) {
        this.setResponseType(responseType);
        return this;
    }

    public DnsServiceDiscovery withResponseType(DnsResponseType responseType) {
        this.responseType = responseType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHostname() != null) {
            sb.append("Hostname: ").append(this.getHostname()).append(",");
        }
        if (this.getIpPreference() != null) {
            sb.append("IpPreference: ").append(this.getIpPreference()).append(",");
        }
        if (this.getResponseType() != null) {
            sb.append("ResponseType: ").append(this.getResponseType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsServiceDiscovery)) {
            return false;
        }
        DnsServiceDiscovery other = (DnsServiceDiscovery)obj;
        if (other.getHostname() == null ^ this.getHostname() == null) {
            return false;
        }
        if (other.getHostname() != null && !other.getHostname().equals(this.getHostname())) {
            return false;
        }
        if (other.getIpPreference() == null ^ this.getIpPreference() == null) {
            return false;
        }
        if (other.getIpPreference() != null && !other.getIpPreference().equals(this.getIpPreference())) {
            return false;
        }
        if (other.getResponseType() == null ^ this.getResponseType() == null) {
            return false;
        }
        return other.getResponseType() == null || other.getResponseType().equals(this.getResponseType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHostname() == null ? 0 : this.getHostname().hashCode());
        hashCode = 31 * hashCode + (this.getIpPreference() == null ? 0 : this.getIpPreference().hashCode());
        hashCode = 31 * hashCode + (this.getResponseType() == null ? 0 : this.getResponseType().hashCode());
        return hashCode;
    }

    public DnsServiceDiscovery clone() {
        try {
            return (DnsServiceDiscovery)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DnsServiceDiscoveryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

