/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationsignals.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationsignals.model.Dimension;
import com.amazonaws.services.applicationsignals.model.transform.MetricReferenceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MetricReference
implements Serializable,
Cloneable,
StructuredPojo {
    private String namespace;
    private String metricType;
    private List<Dimension> dimensions;
    private String metricName;

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public MetricReference withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setMetricType(String metricType) {
        this.metricType = metricType;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public MetricReference withMetricType(String metricType) {
        this.setMetricType(metricType);
        return this;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new ArrayList<Dimension>(dimensions);
    }

    public MetricReference withDimensions(Dimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new ArrayList<Dimension>(dimensions.length));
        }
        for (Dimension ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public MetricReference withDimensions(Collection<Dimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public MetricReference withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getMetricType() != null) {
            sb.append("MetricType: ").append(this.getMetricType()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricReference)) {
            return false;
        }
        MetricReference other = (MetricReference)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getMetricType() == null ^ this.getMetricType() == null) {
            return false;
        }
        if (other.getMetricType() != null && !other.getMetricType().equals(this.getMetricType())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        return other.getMetricName() == null || other.getMetricName().equals(this.getMetricName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetricType() == null ? 0 : this.getMetricType().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        return hashCode;
    }

    public MetricReference clone() {
        try {
            return (MetricReference)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricReferenceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

