/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.applicationinsights.model.transform;

import java.util.Map;
import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.applicationinsights.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ApplicationComponent JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ApplicationComponentJsonUnmarshaller implements Unmarshaller<ApplicationComponent, JsonUnmarshallerContext> {

    public ApplicationComponent unmarshall(JsonUnmarshallerContext context) throws Exception {
        ApplicationComponent applicationComponent = new ApplicationComponent();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ComponentName", targetDepth)) {
                    context.nextToken();
                    applicationComponent.setComponentName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ComponentRemarks", targetDepth)) {
                    context.nextToken();
                    applicationComponent.setComponentRemarks(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ResourceType", targetDepth)) {
                    context.nextToken();
                    applicationComponent.setResourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("OsType", targetDepth)) {
                    context.nextToken();
                    applicationComponent.setOsType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Tier", targetDepth)) {
                    context.nextToken();
                    applicationComponent.setTier(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Monitor", targetDepth)) {
                    context.nextToken();
                    applicationComponent.setMonitor(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("DetectedWorkload", targetDepth)) {
                    context.nextToken();
                    applicationComponent.setDetectedWorkload(new MapUnmarshaller<String, java.util.Map<String, String>>(context.getUnmarshaller(String.class),
                            new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)))
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return applicationComponent;
    }

    private static ApplicationComponentJsonUnmarshaller instance;

    public static ApplicationComponentJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new ApplicationComponentJsonUnmarshaller();
        return instance;
    }
}
