/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.applicationautoscaling.model.ScalableTarget;
import java.util.Date;

@SdkInternalApi
public class ScalableTargetMarshaller {
    private static final MarshallingInfo<String> SERVICENAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceNamespace").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").build();
    private static final MarshallingInfo<String> SCALABLEDIMENSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScalableDimension").build();
    private static final MarshallingInfo<Integer> MINCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinCapacity").build();
    private static final MarshallingInfo<Integer> MAXCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxCapacity").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final ScalableTargetMarshaller instance = new ScalableTargetMarshaller();

    public static ScalableTargetMarshaller getInstance() {
        return instance;
    }

    public void marshall(ScalableTarget scalableTarget, ProtocolMarshaller protocolMarshaller) {
        if (scalableTarget == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)scalableTarget.getServiceNamespace(), SERVICENAMESPACE_BINDING);
            protocolMarshaller.marshall((Object)scalableTarget.getResourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)scalableTarget.getScalableDimension(), SCALABLEDIMENSION_BINDING);
            protocolMarshaller.marshall((Object)scalableTarget.getMinCapacity(), MINCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)scalableTarget.getMaxCapacity(), MAXCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)scalableTarget.getRoleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)scalableTarget.getCreationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

