/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationautoscaling.model.MetricDimension;
import com.amazonaws.services.applicationautoscaling.model.MetricStatistic;
import com.amazonaws.services.applicationautoscaling.model.transform.CustomizedMetricSpecificationMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CustomizedMetricSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String metricName;
    private String namespace;
    private List<MetricDimension> dimensions;
    private String statistic;
    private String unit;

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public CustomizedMetricSpecification withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CustomizedMetricSpecification withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public List<MetricDimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Collection<MetricDimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new ArrayList<MetricDimension>(dimensions);
    }

    public CustomizedMetricSpecification withDimensions(MetricDimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new ArrayList<MetricDimension>(dimensions.length));
        }
        for (MetricDimension ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public CustomizedMetricSpecification withDimensions(Collection<MetricDimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setStatistic(String statistic) {
        this.statistic = statistic;
    }

    @JsonProperty(value="statistic")
    public String getStatistic() {
        return this.statistic;
    }

    public CustomizedMetricSpecification withStatistic(String statistic) {
        this.setStatistic(statistic);
        return this;
    }

    @JsonIgnore
    public void setStatistic(MetricStatistic statistic) {
        this.withStatistic(statistic);
    }

    public CustomizedMetricSpecification withStatistic(MetricStatistic statistic) {
        this.statistic = statistic.toString();
        return this;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public CustomizedMetricSpecification withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getStatistic() != null) {
            sb.append("Statistic: ").append(this.getStatistic()).append(",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: ").append(this.getUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomizedMetricSpecification)) {
            return false;
        }
        CustomizedMetricSpecification other = (CustomizedMetricSpecification)obj;
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getStatistic() == null ^ this.getStatistic() == null) {
            return false;
        }
        if (other.getStatistic() != null && !other.getStatistic().equals(this.getStatistic())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        return other.getUnit() == null || other.getUnit().equals(this.getUnit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getStatistic() == null ? 0 : this.getStatistic().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        return hashCode;
    }

    public CustomizedMetricSpecification clone() {
        try {
            return (CustomizedMetricSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomizedMetricSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

