/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appintegrations.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appintegrations.model.ApplicationSourceConfig;
import com.amazonaws.services.appintegrations.model.Publication;
import com.amazonaws.services.appintegrations.model.Subscription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateApplicationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String namespace;
    private String description;
    private ApplicationSourceConfig applicationSourceConfig;
    @Deprecated
    private List<Subscription> subscriptions;
    @Deprecated
    private List<Publication> publications;
    private String clientToken;
    private Map<String, String> tags;
    private List<String> permissions;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateApplicationRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CreateApplicationRequest withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateApplicationRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setApplicationSourceConfig(ApplicationSourceConfig applicationSourceConfig) {
        this.applicationSourceConfig = applicationSourceConfig;
    }

    public ApplicationSourceConfig getApplicationSourceConfig() {
        return this.applicationSourceConfig;
    }

    public CreateApplicationRequest withApplicationSourceConfig(ApplicationSourceConfig applicationSourceConfig) {
        this.setApplicationSourceConfig(applicationSourceConfig);
        return this;
    }

    @Deprecated
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Deprecated
    public void setSubscriptions(Collection<Subscription> subscriptions) {
        if (subscriptions == null) {
            this.subscriptions = null;
            return;
        }
        this.subscriptions = new ArrayList<Subscription>(subscriptions);
    }

    @Deprecated
    public CreateApplicationRequest withSubscriptions(Subscription ... subscriptions) {
        if (this.subscriptions == null) {
            this.setSubscriptions(new ArrayList<Subscription>(subscriptions.length));
        }
        for (Subscription ele : subscriptions) {
            this.subscriptions.add(ele);
        }
        return this;
    }

    @Deprecated
    public CreateApplicationRequest withSubscriptions(Collection<Subscription> subscriptions) {
        this.setSubscriptions(subscriptions);
        return this;
    }

    @Deprecated
    public List<Publication> getPublications() {
        return this.publications;
    }

    @Deprecated
    public void setPublications(Collection<Publication> publications) {
        if (publications == null) {
            this.publications = null;
            return;
        }
        this.publications = new ArrayList<Publication>(publications);
    }

    @Deprecated
    public CreateApplicationRequest withPublications(Publication ... publications) {
        if (this.publications == null) {
            this.setPublications(new ArrayList<Publication>(publications.length));
        }
        for (Publication ele : publications) {
            this.publications.add(ele);
        }
        return this;
    }

    @Deprecated
    public CreateApplicationRequest withPublications(Collection<Publication> publications) {
        this.setPublications(publications);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateApplicationRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateApplicationRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateApplicationRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateApplicationRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<String> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<String>(permissions);
    }

    public CreateApplicationRequest withPermissions(String ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<String>(permissions.length));
        }
        for (String ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public CreateApplicationRequest withPermissions(Collection<String> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getApplicationSourceConfig() != null) {
            sb.append("ApplicationSourceConfig: ").append(this.getApplicationSourceConfig()).append(",");
        }
        if (this.getSubscriptions() != null) {
            sb.append("Subscriptions: ").append(this.getSubscriptions()).append(",");
        }
        if (this.getPublications() != null) {
            sb.append("Publications: ").append(this.getPublications()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getApplicationSourceConfig() == null ^ this.getApplicationSourceConfig() == null) {
            return false;
        }
        if (other.getApplicationSourceConfig() != null && !other.getApplicationSourceConfig().equals(this.getApplicationSourceConfig())) {
            return false;
        }
        if (other.getSubscriptions() == null ^ this.getSubscriptions() == null) {
            return false;
        }
        if (other.getSubscriptions() != null && !other.getSubscriptions().equals(this.getSubscriptions())) {
            return false;
        }
        if (other.getPublications() == null ^ this.getPublications() == null) {
            return false;
        }
        if (other.getPublications() != null && !other.getPublications().equals(this.getPublications())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        return other.getPermissions() == null || other.getPermissions().equals(this.getPermissions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationSourceConfig() == null ? 0 : this.getApplicationSourceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getSubscriptions() == null ? 0 : this.getSubscriptions().hashCode());
        hashCode = 31 * hashCode + (this.getPublications() == null ? 0 : this.getPublications().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        return hashCode;
    }

    public CreateApplicationRequest clone() {
        return (CreateApplicationRequest)super.clone();
    }
}

