/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appflow.model.OAuth2Properties;
import java.util.Map;

@SdkInternalApi
public class OAuth2PropertiesMarshaller {
    private static final MarshallingInfo<String> TOKENURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenUrl").build();
    private static final MarshallingInfo<String> OAUTH2GRANTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("oAuth2GrantType").build();
    private static final MarshallingInfo<Map> TOKENURLCUSTOMPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenUrlCustomProperties").build();
    private static final OAuth2PropertiesMarshaller instance = new OAuth2PropertiesMarshaller();

    public static OAuth2PropertiesMarshaller getInstance() {
        return instance;
    }

    public void marshall(OAuth2Properties oAuth2Properties, ProtocolMarshaller protocolMarshaller) {
        if (oAuth2Properties == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)oAuth2Properties.getTokenUrl(), TOKENURL_BINDING);
            protocolMarshaller.marshall((Object)oAuth2Properties.getOAuth2GrantType(), OAUTH2GRANTTYPE_BINDING);
            protocolMarshaller.marshall(oAuth2Properties.getTokenUrlCustomProperties(), TOKENURLCUSTOMPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

