/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.SAPODataPaginationConfig;
import com.amazonaws.services.appflow.model.SAPODataParallelismConfig;
import com.amazonaws.services.appflow.model.transform.SAPODataSourcePropertiesMarshaller;
import java.io.Serializable;

public class SAPODataSourceProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private String objectPath;
    private SAPODataParallelismConfig parallelismConfig;
    private SAPODataPaginationConfig paginationConfig;

    public void setObjectPath(String objectPath) {
        this.objectPath = objectPath;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public SAPODataSourceProperties withObjectPath(String objectPath) {
        this.setObjectPath(objectPath);
        return this;
    }

    public void setParallelismConfig(SAPODataParallelismConfig parallelismConfig) {
        this.parallelismConfig = parallelismConfig;
    }

    public SAPODataParallelismConfig getParallelismConfig() {
        return this.parallelismConfig;
    }

    public SAPODataSourceProperties withParallelismConfig(SAPODataParallelismConfig parallelismConfig) {
        this.setParallelismConfig(parallelismConfig);
        return this;
    }

    public void setPaginationConfig(SAPODataPaginationConfig paginationConfig) {
        this.paginationConfig = paginationConfig;
    }

    public SAPODataPaginationConfig getPaginationConfig() {
        return this.paginationConfig;
    }

    public SAPODataSourceProperties withPaginationConfig(SAPODataPaginationConfig paginationConfig) {
        this.setPaginationConfig(paginationConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getObjectPath() != null) {
            sb.append("ObjectPath: ").append(this.getObjectPath()).append(",");
        }
        if (this.getParallelismConfig() != null) {
            sb.append("ParallelismConfig: ").append(this.getParallelismConfig()).append(",");
        }
        if (this.getPaginationConfig() != null) {
            sb.append("PaginationConfig: ").append(this.getPaginationConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAPODataSourceProperties)) {
            return false;
        }
        SAPODataSourceProperties other = (SAPODataSourceProperties)obj;
        if (other.getObjectPath() == null ^ this.getObjectPath() == null) {
            return false;
        }
        if (other.getObjectPath() != null && !other.getObjectPath().equals(this.getObjectPath())) {
            return false;
        }
        if (other.getParallelismConfig() == null ^ this.getParallelismConfig() == null) {
            return false;
        }
        if (other.getParallelismConfig() != null && !other.getParallelismConfig().equals(this.getParallelismConfig())) {
            return false;
        }
        if (other.getPaginationConfig() == null ^ this.getPaginationConfig() == null) {
            return false;
        }
        return other.getPaginationConfig() == null || other.getPaginationConfig().equals(this.getPaginationConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getObjectPath() == null ? 0 : this.getObjectPath().hashCode());
        hashCode = 31 * hashCode + (this.getParallelismConfig() == null ? 0 : this.getParallelismConfig().hashCode());
        hashCode = 31 * hashCode + (this.getPaginationConfig() == null ? 0 : this.getPaginationConfig().hashCode());
        return hashCode;
    }

    public SAPODataSourceProperties clone() {
        try {
            return (SAPODataSourceProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SAPODataSourcePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

