/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.AuthParameter;
import com.amazonaws.services.appflow.model.transform.CustomAuthConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CustomAuthConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String customAuthenticationType;
    private List<AuthParameter> authParameters;

    public void setCustomAuthenticationType(String customAuthenticationType) {
        this.customAuthenticationType = customAuthenticationType;
    }

    public String getCustomAuthenticationType() {
        return this.customAuthenticationType;
    }

    public CustomAuthConfig withCustomAuthenticationType(String customAuthenticationType) {
        this.setCustomAuthenticationType(customAuthenticationType);
        return this;
    }

    public List<AuthParameter> getAuthParameters() {
        return this.authParameters;
    }

    public void setAuthParameters(Collection<AuthParameter> authParameters) {
        if (authParameters == null) {
            this.authParameters = null;
            return;
        }
        this.authParameters = new ArrayList<AuthParameter>(authParameters);
    }

    public CustomAuthConfig withAuthParameters(AuthParameter ... authParameters) {
        if (this.authParameters == null) {
            this.setAuthParameters(new ArrayList<AuthParameter>(authParameters.length));
        }
        for (AuthParameter ele : authParameters) {
            this.authParameters.add(ele);
        }
        return this;
    }

    public CustomAuthConfig withAuthParameters(Collection<AuthParameter> authParameters) {
        this.setAuthParameters(authParameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCustomAuthenticationType() != null) {
            sb.append("CustomAuthenticationType: ").append(this.getCustomAuthenticationType()).append(",");
        }
        if (this.getAuthParameters() != null) {
            sb.append("AuthParameters: ").append(this.getAuthParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomAuthConfig)) {
            return false;
        }
        CustomAuthConfig other = (CustomAuthConfig)obj;
        if (other.getCustomAuthenticationType() == null ^ this.getCustomAuthenticationType() == null) {
            return false;
        }
        if (other.getCustomAuthenticationType() != null && !other.getCustomAuthenticationType().equals(this.getCustomAuthenticationType())) {
            return false;
        }
        if (other.getAuthParameters() == null ^ this.getAuthParameters() == null) {
            return false;
        }
        return other.getAuthParameters() == null || other.getAuthParameters().equals(this.getAuthParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCustomAuthenticationType() == null ? 0 : this.getCustomAuthenticationType().hashCode());
        hashCode = 31 * hashCode + (this.getAuthParameters() == null ? 0 : this.getAuthParameters().hashCode());
        return hashCode;
    }

    public CustomAuthConfig clone() {
        try {
            return (CustomAuthConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomAuthConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

