/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.appflow.AmazonAppflow;
import com.amazonaws.services.appflow.AmazonAppflowClientBuilder;
import com.amazonaws.services.appflow.model.AmazonAppflowException;
import com.amazonaws.services.appflow.model.CancelFlowExecutionsRequest;
import com.amazonaws.services.appflow.model.CancelFlowExecutionsResult;
import com.amazonaws.services.appflow.model.CreateConnectorProfileRequest;
import com.amazonaws.services.appflow.model.CreateConnectorProfileResult;
import com.amazonaws.services.appflow.model.CreateFlowRequest;
import com.amazonaws.services.appflow.model.CreateFlowResult;
import com.amazonaws.services.appflow.model.DeleteConnectorProfileRequest;
import com.amazonaws.services.appflow.model.DeleteConnectorProfileResult;
import com.amazonaws.services.appflow.model.DeleteFlowRequest;
import com.amazonaws.services.appflow.model.DeleteFlowResult;
import com.amazonaws.services.appflow.model.DescribeConnectorEntityRequest;
import com.amazonaws.services.appflow.model.DescribeConnectorEntityResult;
import com.amazonaws.services.appflow.model.DescribeConnectorProfilesRequest;
import com.amazonaws.services.appflow.model.DescribeConnectorProfilesResult;
import com.amazonaws.services.appflow.model.DescribeConnectorRequest;
import com.amazonaws.services.appflow.model.DescribeConnectorResult;
import com.amazonaws.services.appflow.model.DescribeConnectorsRequest;
import com.amazonaws.services.appflow.model.DescribeConnectorsResult;
import com.amazonaws.services.appflow.model.DescribeFlowExecutionRecordsRequest;
import com.amazonaws.services.appflow.model.DescribeFlowExecutionRecordsResult;
import com.amazonaws.services.appflow.model.DescribeFlowRequest;
import com.amazonaws.services.appflow.model.DescribeFlowResult;
import com.amazonaws.services.appflow.model.ListConnectorEntitiesRequest;
import com.amazonaws.services.appflow.model.ListConnectorEntitiesResult;
import com.amazonaws.services.appflow.model.ListConnectorsRequest;
import com.amazonaws.services.appflow.model.ListConnectorsResult;
import com.amazonaws.services.appflow.model.ListFlowsRequest;
import com.amazonaws.services.appflow.model.ListFlowsResult;
import com.amazonaws.services.appflow.model.ListTagsForResourceRequest;
import com.amazonaws.services.appflow.model.ListTagsForResourceResult;
import com.amazonaws.services.appflow.model.RegisterConnectorRequest;
import com.amazonaws.services.appflow.model.RegisterConnectorResult;
import com.amazonaws.services.appflow.model.StartFlowRequest;
import com.amazonaws.services.appflow.model.StartFlowResult;
import com.amazonaws.services.appflow.model.StopFlowRequest;
import com.amazonaws.services.appflow.model.StopFlowResult;
import com.amazonaws.services.appflow.model.TagResourceRequest;
import com.amazonaws.services.appflow.model.TagResourceResult;
import com.amazonaws.services.appflow.model.UnregisterConnectorRequest;
import com.amazonaws.services.appflow.model.UnregisterConnectorResult;
import com.amazonaws.services.appflow.model.UntagResourceRequest;
import com.amazonaws.services.appflow.model.UntagResourceResult;
import com.amazonaws.services.appflow.model.UpdateConnectorProfileRequest;
import com.amazonaws.services.appflow.model.UpdateConnectorProfileResult;
import com.amazonaws.services.appflow.model.UpdateConnectorRegistrationRequest;
import com.amazonaws.services.appflow.model.UpdateConnectorRegistrationResult;
import com.amazonaws.services.appflow.model.UpdateFlowRequest;
import com.amazonaws.services.appflow.model.UpdateFlowResult;
import com.amazonaws.services.appflow.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.appflow.model.transform.CancelFlowExecutionsRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.CancelFlowExecutionsResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.appflow.model.transform.ConnectorAuthenticationExceptionUnmarshaller;
import com.amazonaws.services.appflow.model.transform.ConnectorServerExceptionUnmarshaller;
import com.amazonaws.services.appflow.model.transform.CreateConnectorProfileRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.CreateConnectorProfileResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.CreateFlowRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.CreateFlowResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.DeleteConnectorProfileRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.DeleteConnectorProfileResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.DeleteFlowRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.DeleteFlowResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.DescribeConnectorEntityRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.DescribeConnectorEntityResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.DescribeConnectorProfilesRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.DescribeConnectorProfilesResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.DescribeConnectorRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.DescribeConnectorResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.DescribeConnectorsRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.DescribeConnectorsResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.DescribeFlowExecutionRecordsRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.DescribeFlowExecutionRecordsResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.DescribeFlowRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.DescribeFlowResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.appflow.model.transform.ListConnectorEntitiesRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.ListConnectorEntitiesResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.ListConnectorsRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.ListConnectorsResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.ListFlowsRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.ListFlowsResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.RegisterConnectorRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.RegisterConnectorResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.appflow.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.appflow.model.transform.StartFlowRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.StartFlowResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.StopFlowRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.StopFlowResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.appflow.model.transform.UnregisterConnectorRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.UnregisterConnectorResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.UnsupportedOperationExceptionUnmarshaller;
import com.amazonaws.services.appflow.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.UpdateConnectorProfileRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.UpdateConnectorProfileResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.UpdateConnectorRegistrationRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.UpdateConnectorRegistrationResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.UpdateFlowRequestProtocolMarshaller;
import com.amazonaws.services.appflow.model.transform.UpdateFlowResultJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonAppflowClient
extends AmazonWebServiceClient
implements AmazonAppflow {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonAppflow.class);
    private static final String DEFAULT_SIGNING_NAME = "appflow";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedOperationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedOperationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConnectorAuthenticationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConnectorAuthenticationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConnectorServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConnectorServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonAppflowException.class));

    public static AmazonAppflowClientBuilder builder() {
        return AmazonAppflowClientBuilder.standard();
    }

    AmazonAppflowClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonAppflowClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("appflow.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/appflow/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/appflow/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelFlowExecutionsResult cancelFlowExecutions(CancelFlowExecutionsRequest request) {
        request = (CancelFlowExecutionsRequest)this.beforeClientExecution(request);
        return this.executeCancelFlowExecutions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelFlowExecutionsResult executeCancelFlowExecutions(CancelFlowExecutionsRequest cancelFlowExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelFlowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelFlowExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelFlowExecutionsRequestProtocolMarshaller(protocolFactory).marshall((CancelFlowExecutionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelFlowExecutionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelFlowExecutions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelFlowExecutionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelFlowExecutionsResult cancelFlowExecutionsResult = (CancelFlowExecutionsResult)response.getAwsResponse();
            return cancelFlowExecutionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateConnectorProfileResult createConnectorProfile(CreateConnectorProfileRequest request) {
        request = (CreateConnectorProfileRequest)this.beforeClientExecution(request);
        return this.executeCreateConnectorProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateConnectorProfileResult executeCreateConnectorProfile(CreateConnectorProfileRequest createConnectorProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createConnectorProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateConnectorProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateConnectorProfileRequestProtocolMarshaller(protocolFactory).marshall((CreateConnectorProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)createConnectorProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateConnectorProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateConnectorProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateConnectorProfileResult createConnectorProfileResult = (CreateConnectorProfileResult)response.getAwsResponse();
            return createConnectorProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateFlowResult createFlow(CreateFlowRequest request) {
        request = (CreateFlowRequest)this.beforeClientExecution(request);
        return this.executeCreateFlow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateFlowResult executeCreateFlow(CreateFlowRequest createFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFlowRequestProtocolMarshaller(protocolFactory).marshall((CreateFlowRequest)super.beforeMarshalling((AmazonWebServiceRequest)createFlowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateFlow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFlowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFlowResult createFlowResult = (CreateFlowResult)response.getAwsResponse();
            return createFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteConnectorProfileResult deleteConnectorProfile(DeleteConnectorProfileRequest request) {
        request = (DeleteConnectorProfileRequest)this.beforeClientExecution(request);
        return this.executeDeleteConnectorProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteConnectorProfileResult executeDeleteConnectorProfile(DeleteConnectorProfileRequest deleteConnectorProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConnectorProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteConnectorProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteConnectorProfileRequestProtocolMarshaller(protocolFactory).marshall((DeleteConnectorProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteConnectorProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteConnectorProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteConnectorProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteConnectorProfileResult deleteConnectorProfileResult = (DeleteConnectorProfileResult)response.getAwsResponse();
            return deleteConnectorProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteFlowResult deleteFlow(DeleteFlowRequest request) {
        request = (DeleteFlowRequest)this.beforeClientExecution(request);
        return this.executeDeleteFlow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteFlowResult executeDeleteFlow(DeleteFlowRequest deleteFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFlowRequestProtocolMarshaller(protocolFactory).marshall((DeleteFlowRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteFlowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteFlow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFlowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFlowResult deleteFlowResult = (DeleteFlowResult)response.getAwsResponse();
            return deleteFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeConnectorResult describeConnector(DescribeConnectorRequest request) {
        request = (DescribeConnectorRequest)this.beforeClientExecution(request);
        return this.executeDescribeConnector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeConnectorResult executeDescribeConnector(DescribeConnectorRequest describeConnectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConnectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConnectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConnectorRequestProtocolMarshaller(protocolFactory).marshall((DescribeConnectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeConnectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeConnector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConnectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConnectorResult describeConnectorResult = (DescribeConnectorResult)response.getAwsResponse();
            return describeConnectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeConnectorEntityResult describeConnectorEntity(DescribeConnectorEntityRequest request) {
        request = (DescribeConnectorEntityRequest)this.beforeClientExecution(request);
        return this.executeDescribeConnectorEntity(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeConnectorEntityResult executeDescribeConnectorEntity(DescribeConnectorEntityRequest describeConnectorEntityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConnectorEntityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConnectorEntityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConnectorEntityRequestProtocolMarshaller(protocolFactory).marshall((DescribeConnectorEntityRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeConnectorEntityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeConnectorEntity");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConnectorEntityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConnectorEntityResult describeConnectorEntityResult = (DescribeConnectorEntityResult)response.getAwsResponse();
            return describeConnectorEntityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeConnectorProfilesResult describeConnectorProfiles(DescribeConnectorProfilesRequest request) {
        request = (DescribeConnectorProfilesRequest)this.beforeClientExecution(request);
        return this.executeDescribeConnectorProfiles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeConnectorProfilesResult executeDescribeConnectorProfiles(DescribeConnectorProfilesRequest describeConnectorProfilesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConnectorProfilesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConnectorProfilesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConnectorProfilesRequestProtocolMarshaller(protocolFactory).marshall((DescribeConnectorProfilesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeConnectorProfilesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeConnectorProfiles");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConnectorProfilesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConnectorProfilesResult describeConnectorProfilesResult = (DescribeConnectorProfilesResult)response.getAwsResponse();
            return describeConnectorProfilesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeConnectorsResult describeConnectors(DescribeConnectorsRequest request) {
        request = (DescribeConnectorsRequest)this.beforeClientExecution(request);
        return this.executeDescribeConnectors(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeConnectorsResult executeDescribeConnectors(DescribeConnectorsRequest describeConnectorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConnectorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConnectorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConnectorsRequestProtocolMarshaller(protocolFactory).marshall((DescribeConnectorsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeConnectorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeConnectors");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConnectorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConnectorsResult describeConnectorsResult = (DescribeConnectorsResult)response.getAwsResponse();
            return describeConnectorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFlowResult describeFlow(DescribeFlowRequest request) {
        request = (DescribeFlowRequest)this.beforeClientExecution(request);
        return this.executeDescribeFlow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFlowResult executeDescribeFlow(DescribeFlowRequest describeFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFlowRequestProtocolMarshaller(protocolFactory).marshall((DescribeFlowRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFlowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeFlow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFlowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFlowResult describeFlowResult = (DescribeFlowResult)response.getAwsResponse();
            return describeFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFlowExecutionRecordsResult describeFlowExecutionRecords(DescribeFlowExecutionRecordsRequest request) {
        request = (DescribeFlowExecutionRecordsRequest)this.beforeClientExecution(request);
        return this.executeDescribeFlowExecutionRecords(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFlowExecutionRecordsResult executeDescribeFlowExecutionRecords(DescribeFlowExecutionRecordsRequest describeFlowExecutionRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFlowExecutionRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFlowExecutionRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFlowExecutionRecordsRequestProtocolMarshaller(protocolFactory).marshall((DescribeFlowExecutionRecordsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFlowExecutionRecordsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeFlowExecutionRecords");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFlowExecutionRecordsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFlowExecutionRecordsResult describeFlowExecutionRecordsResult = (DescribeFlowExecutionRecordsResult)response.getAwsResponse();
            return describeFlowExecutionRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListConnectorEntitiesResult listConnectorEntities(ListConnectorEntitiesRequest request) {
        request = (ListConnectorEntitiesRequest)this.beforeClientExecution(request);
        return this.executeListConnectorEntities(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListConnectorEntitiesResult executeListConnectorEntities(ListConnectorEntitiesRequest listConnectorEntitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listConnectorEntitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListConnectorEntitiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListConnectorEntitiesRequestProtocolMarshaller(protocolFactory).marshall((ListConnectorEntitiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listConnectorEntitiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListConnectorEntities");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListConnectorEntitiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListConnectorEntitiesResult listConnectorEntitiesResult = (ListConnectorEntitiesResult)response.getAwsResponse();
            return listConnectorEntitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListConnectorsResult listConnectors(ListConnectorsRequest request) {
        request = (ListConnectorsRequest)this.beforeClientExecution(request);
        return this.executeListConnectors(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListConnectorsResult executeListConnectors(ListConnectorsRequest listConnectorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listConnectorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListConnectorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListConnectorsRequestProtocolMarshaller(protocolFactory).marshall((ListConnectorsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listConnectorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListConnectors");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListConnectorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListConnectorsResult listConnectorsResult = (ListConnectorsResult)response.getAwsResponse();
            return listConnectorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFlowsResult listFlows(ListFlowsRequest request) {
        request = (ListFlowsRequest)this.beforeClientExecution(request);
        return this.executeListFlows(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFlowsResult executeListFlows(ListFlowsRequest listFlowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFlowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFlowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFlowsRequestProtocolMarshaller(protocolFactory).marshall((ListFlowsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFlowsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListFlows");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFlowsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFlowsResult listFlowsResult = (ListFlowsResult)response.getAwsResponse();
            return listFlowsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterConnectorResult registerConnector(RegisterConnectorRequest request) {
        request = (RegisterConnectorRequest)this.beforeClientExecution(request);
        return this.executeRegisterConnector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterConnectorResult executeRegisterConnector(RegisterConnectorRequest registerConnectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerConnectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterConnectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterConnectorRequestProtocolMarshaller(protocolFactory).marshall((RegisterConnectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerConnectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterConnector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterConnectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterConnectorResult registerConnectorResult = (RegisterConnectorResult)response.getAwsResponse();
            return registerConnectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartFlowResult startFlow(StartFlowRequest request) {
        request = (StartFlowRequest)this.beforeClientExecution(request);
        return this.executeStartFlow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartFlowResult executeStartFlow(StartFlowRequest startFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartFlowRequestProtocolMarshaller(protocolFactory).marshall((StartFlowRequest)super.beforeMarshalling((AmazonWebServiceRequest)startFlowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartFlow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartFlowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartFlowResult startFlowResult = (StartFlowResult)response.getAwsResponse();
            return startFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopFlowResult stopFlow(StopFlowRequest request) {
        request = (StopFlowRequest)this.beforeClientExecution(request);
        return this.executeStopFlow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopFlowResult executeStopFlow(StopFlowRequest stopFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopFlowRequestProtocolMarshaller(protocolFactory).marshall((StopFlowRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopFlowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopFlow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopFlowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopFlowResult stopFlowResult = (StopFlowResult)response.getAwsResponse();
            return stopFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UnregisterConnectorResult unregisterConnector(UnregisterConnectorRequest request) {
        request = (UnregisterConnectorRequest)this.beforeClientExecution(request);
        return this.executeUnregisterConnector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UnregisterConnectorResult executeUnregisterConnector(UnregisterConnectorRequest unregisterConnectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(unregisterConnectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UnregisterConnectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UnregisterConnectorRequestProtocolMarshaller(protocolFactory).marshall((UnregisterConnectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)unregisterConnectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UnregisterConnector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UnregisterConnectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UnregisterConnectorResult unregisterConnectorResult = (UnregisterConnectorResult)response.getAwsResponse();
            return unregisterConnectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateConnectorProfileResult updateConnectorProfile(UpdateConnectorProfileRequest request) {
        request = (UpdateConnectorProfileRequest)this.beforeClientExecution(request);
        return this.executeUpdateConnectorProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateConnectorProfileResult executeUpdateConnectorProfile(UpdateConnectorProfileRequest updateConnectorProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateConnectorProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateConnectorProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateConnectorProfileRequestProtocolMarshaller(protocolFactory).marshall((UpdateConnectorProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateConnectorProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateConnectorProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateConnectorProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateConnectorProfileResult updateConnectorProfileResult = (UpdateConnectorProfileResult)response.getAwsResponse();
            return updateConnectorProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateConnectorRegistrationResult updateConnectorRegistration(UpdateConnectorRegistrationRequest request) {
        request = (UpdateConnectorRegistrationRequest)this.beforeClientExecution(request);
        return this.executeUpdateConnectorRegistration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateConnectorRegistrationResult executeUpdateConnectorRegistration(UpdateConnectorRegistrationRequest updateConnectorRegistrationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateConnectorRegistrationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateConnectorRegistrationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateConnectorRegistrationRequestProtocolMarshaller(protocolFactory).marshall((UpdateConnectorRegistrationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateConnectorRegistrationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateConnectorRegistration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateConnectorRegistrationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateConnectorRegistrationResult updateConnectorRegistrationResult = (UpdateConnectorRegistrationResult)response.getAwsResponse();
            return updateConnectorRegistrationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateFlowResult updateFlow(UpdateFlowRequest request) {
        request = (UpdateFlowRequest)this.beforeClientExecution(request);
        return this.executeUpdateFlow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateFlowResult executeUpdateFlow(UpdateFlowRequest updateFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFlowRequestProtocolMarshaller(protocolFactory).marshall((UpdateFlowRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFlowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Appflow");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateFlow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFlowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFlowResult updateFlowResult = (UpdateFlowResult)response.getAwsResponse();
            return updateFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

