/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.transform.CustomConnectorSourcePropertiesMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CustomConnectorSourceProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private String entityName;
    private Map<String, String> customProperties;

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public CustomConnectorSourceProperties withEntityName(String entityName) {
        this.setEntityName(entityName);
        return this;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    public CustomConnectorSourceProperties withCustomProperties(Map<String, String> customProperties) {
        this.setCustomProperties(customProperties);
        return this;
    }

    public CustomConnectorSourceProperties addCustomPropertiesEntry(String key, String value) {
        if (null == this.customProperties) {
            this.customProperties = new HashMap<String, String>();
        }
        if (this.customProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.customProperties.put(key, value);
        return this;
    }

    public CustomConnectorSourceProperties clearCustomPropertiesEntries() {
        this.customProperties = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntityName() != null) {
            sb.append("EntityName: ").append(this.getEntityName()).append(",");
        }
        if (this.getCustomProperties() != null) {
            sb.append("CustomProperties: ").append(this.getCustomProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConnectorSourceProperties)) {
            return false;
        }
        CustomConnectorSourceProperties other = (CustomConnectorSourceProperties)obj;
        if (other.getEntityName() == null ^ this.getEntityName() == null) {
            return false;
        }
        if (other.getEntityName() != null && !other.getEntityName().equals(this.getEntityName())) {
            return false;
        }
        if (other.getCustomProperties() == null ^ this.getCustomProperties() == null) {
            return false;
        }
        return other.getCustomProperties() == null || other.getCustomProperties().equals(this.getCustomProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntityName() == null ? 0 : this.getEntityName().hashCode());
        hashCode = 31 * hashCode + (this.getCustomProperties() == null ? 0 : this.getCustomProperties().hashCode());
        return hashCode;
    }

    public CustomConnectorSourceProperties clone() {
        try {
            return (CustomConnectorSourceProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomConnectorSourcePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

