/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.appflow.AmazonAppflowAsync;
import com.amazonaws.services.appflow.AmazonAppflowAsyncClientBuilder;
import com.amazonaws.services.appflow.AmazonAppflowClient;
import com.amazonaws.services.appflow.model.CreateConnectorProfileRequest;
import com.amazonaws.services.appflow.model.CreateConnectorProfileResult;
import com.amazonaws.services.appflow.model.CreateFlowRequest;
import com.amazonaws.services.appflow.model.CreateFlowResult;
import com.amazonaws.services.appflow.model.DeleteConnectorProfileRequest;
import com.amazonaws.services.appflow.model.DeleteConnectorProfileResult;
import com.amazonaws.services.appflow.model.DeleteFlowRequest;
import com.amazonaws.services.appflow.model.DeleteFlowResult;
import com.amazonaws.services.appflow.model.DescribeConnectorEntityRequest;
import com.amazonaws.services.appflow.model.DescribeConnectorEntityResult;
import com.amazonaws.services.appflow.model.DescribeConnectorProfilesRequest;
import com.amazonaws.services.appflow.model.DescribeConnectorProfilesResult;
import com.amazonaws.services.appflow.model.DescribeConnectorsRequest;
import com.amazonaws.services.appflow.model.DescribeConnectorsResult;
import com.amazonaws.services.appflow.model.DescribeFlowExecutionRecordsRequest;
import com.amazonaws.services.appflow.model.DescribeFlowExecutionRecordsResult;
import com.amazonaws.services.appflow.model.DescribeFlowRequest;
import com.amazonaws.services.appflow.model.DescribeFlowResult;
import com.amazonaws.services.appflow.model.ListConnectorEntitiesRequest;
import com.amazonaws.services.appflow.model.ListConnectorEntitiesResult;
import com.amazonaws.services.appflow.model.ListFlowsRequest;
import com.amazonaws.services.appflow.model.ListFlowsResult;
import com.amazonaws.services.appflow.model.ListTagsForResourceRequest;
import com.amazonaws.services.appflow.model.ListTagsForResourceResult;
import com.amazonaws.services.appflow.model.StartFlowRequest;
import com.amazonaws.services.appflow.model.StartFlowResult;
import com.amazonaws.services.appflow.model.StopFlowRequest;
import com.amazonaws.services.appflow.model.StopFlowResult;
import com.amazonaws.services.appflow.model.TagResourceRequest;
import com.amazonaws.services.appflow.model.TagResourceResult;
import com.amazonaws.services.appflow.model.UntagResourceRequest;
import com.amazonaws.services.appflow.model.UntagResourceResult;
import com.amazonaws.services.appflow.model.UpdateConnectorProfileRequest;
import com.amazonaws.services.appflow.model.UpdateConnectorProfileResult;
import com.amazonaws.services.appflow.model.UpdateFlowRequest;
import com.amazonaws.services.appflow.model.UpdateFlowResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonAppflowAsyncClient
extends AmazonAppflowClient
implements AmazonAppflowAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonAppflowAsyncClientBuilder asyncBuilder() {
        return AmazonAppflowAsyncClientBuilder.standard();
    }

    AmazonAppflowAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonAppflowAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateConnectorProfileResult> createConnectorProfileAsync(CreateConnectorProfileRequest request) {
        return this.createConnectorProfileAsync(request, null);
    }

    @Override
    public Future<CreateConnectorProfileResult> createConnectorProfileAsync(CreateConnectorProfileRequest request, final AsyncHandler<CreateConnectorProfileRequest, CreateConnectorProfileResult> asyncHandler) {
        final CreateConnectorProfileRequest finalRequest = (CreateConnectorProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateConnectorProfileResult>(){

            @Override
            public CreateConnectorProfileResult call() throws Exception {
                CreateConnectorProfileResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeCreateConnectorProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFlowResult> createFlowAsync(CreateFlowRequest request) {
        return this.createFlowAsync(request, null);
    }

    @Override
    public Future<CreateFlowResult> createFlowAsync(CreateFlowRequest request, final AsyncHandler<CreateFlowRequest, CreateFlowResult> asyncHandler) {
        final CreateFlowRequest finalRequest = (CreateFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFlowResult>(){

            @Override
            public CreateFlowResult call() throws Exception {
                CreateFlowResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeCreateFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConnectorProfileResult> deleteConnectorProfileAsync(DeleteConnectorProfileRequest request) {
        return this.deleteConnectorProfileAsync(request, null);
    }

    @Override
    public Future<DeleteConnectorProfileResult> deleteConnectorProfileAsync(DeleteConnectorProfileRequest request, final AsyncHandler<DeleteConnectorProfileRequest, DeleteConnectorProfileResult> asyncHandler) {
        final DeleteConnectorProfileRequest finalRequest = (DeleteConnectorProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteConnectorProfileResult>(){

            @Override
            public DeleteConnectorProfileResult call() throws Exception {
                DeleteConnectorProfileResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeDeleteConnectorProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFlowResult> deleteFlowAsync(DeleteFlowRequest request) {
        return this.deleteFlowAsync(request, null);
    }

    @Override
    public Future<DeleteFlowResult> deleteFlowAsync(DeleteFlowRequest request, final AsyncHandler<DeleteFlowRequest, DeleteFlowResult> asyncHandler) {
        final DeleteFlowRequest finalRequest = (DeleteFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFlowResult>(){

            @Override
            public DeleteFlowResult call() throws Exception {
                DeleteFlowResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeDeleteFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConnectorEntityResult> describeConnectorEntityAsync(DescribeConnectorEntityRequest request) {
        return this.describeConnectorEntityAsync(request, null);
    }

    @Override
    public Future<DescribeConnectorEntityResult> describeConnectorEntityAsync(DescribeConnectorEntityRequest request, final AsyncHandler<DescribeConnectorEntityRequest, DescribeConnectorEntityResult> asyncHandler) {
        final DescribeConnectorEntityRequest finalRequest = (DescribeConnectorEntityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConnectorEntityResult>(){

            @Override
            public DescribeConnectorEntityResult call() throws Exception {
                DescribeConnectorEntityResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeDescribeConnectorEntity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConnectorProfilesResult> describeConnectorProfilesAsync(DescribeConnectorProfilesRequest request) {
        return this.describeConnectorProfilesAsync(request, null);
    }

    @Override
    public Future<DescribeConnectorProfilesResult> describeConnectorProfilesAsync(DescribeConnectorProfilesRequest request, final AsyncHandler<DescribeConnectorProfilesRequest, DescribeConnectorProfilesResult> asyncHandler) {
        final DescribeConnectorProfilesRequest finalRequest = (DescribeConnectorProfilesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConnectorProfilesResult>(){

            @Override
            public DescribeConnectorProfilesResult call() throws Exception {
                DescribeConnectorProfilesResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeDescribeConnectorProfiles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConnectorsResult> describeConnectorsAsync(DescribeConnectorsRequest request) {
        return this.describeConnectorsAsync(request, null);
    }

    @Override
    public Future<DescribeConnectorsResult> describeConnectorsAsync(DescribeConnectorsRequest request, final AsyncHandler<DescribeConnectorsRequest, DescribeConnectorsResult> asyncHandler) {
        final DescribeConnectorsRequest finalRequest = (DescribeConnectorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConnectorsResult>(){

            @Override
            public DescribeConnectorsResult call() throws Exception {
                DescribeConnectorsResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeDescribeConnectors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFlowResult> describeFlowAsync(DescribeFlowRequest request) {
        return this.describeFlowAsync(request, null);
    }

    @Override
    public Future<DescribeFlowResult> describeFlowAsync(DescribeFlowRequest request, final AsyncHandler<DescribeFlowRequest, DescribeFlowResult> asyncHandler) {
        final DescribeFlowRequest finalRequest = (DescribeFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFlowResult>(){

            @Override
            public DescribeFlowResult call() throws Exception {
                DescribeFlowResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeDescribeFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFlowExecutionRecordsResult> describeFlowExecutionRecordsAsync(DescribeFlowExecutionRecordsRequest request) {
        return this.describeFlowExecutionRecordsAsync(request, null);
    }

    @Override
    public Future<DescribeFlowExecutionRecordsResult> describeFlowExecutionRecordsAsync(DescribeFlowExecutionRecordsRequest request, final AsyncHandler<DescribeFlowExecutionRecordsRequest, DescribeFlowExecutionRecordsResult> asyncHandler) {
        final DescribeFlowExecutionRecordsRequest finalRequest = (DescribeFlowExecutionRecordsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFlowExecutionRecordsResult>(){

            @Override
            public DescribeFlowExecutionRecordsResult call() throws Exception {
                DescribeFlowExecutionRecordsResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeDescribeFlowExecutionRecords(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConnectorEntitiesResult> listConnectorEntitiesAsync(ListConnectorEntitiesRequest request) {
        return this.listConnectorEntitiesAsync(request, null);
    }

    @Override
    public Future<ListConnectorEntitiesResult> listConnectorEntitiesAsync(ListConnectorEntitiesRequest request, final AsyncHandler<ListConnectorEntitiesRequest, ListConnectorEntitiesResult> asyncHandler) {
        final ListConnectorEntitiesRequest finalRequest = (ListConnectorEntitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListConnectorEntitiesResult>(){

            @Override
            public ListConnectorEntitiesResult call() throws Exception {
                ListConnectorEntitiesResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeListConnectorEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFlowsResult> listFlowsAsync(ListFlowsRequest request) {
        return this.listFlowsAsync(request, null);
    }

    @Override
    public Future<ListFlowsResult> listFlowsAsync(ListFlowsRequest request, final AsyncHandler<ListFlowsRequest, ListFlowsResult> asyncHandler) {
        final ListFlowsRequest finalRequest = (ListFlowsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFlowsResult>(){

            @Override
            public ListFlowsResult call() throws Exception {
                ListFlowsResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeListFlows(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartFlowResult> startFlowAsync(StartFlowRequest request) {
        return this.startFlowAsync(request, null);
    }

    @Override
    public Future<StartFlowResult> startFlowAsync(StartFlowRequest request, final AsyncHandler<StartFlowRequest, StartFlowResult> asyncHandler) {
        final StartFlowRequest finalRequest = (StartFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartFlowResult>(){

            @Override
            public StartFlowResult call() throws Exception {
                StartFlowResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeStartFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopFlowResult> stopFlowAsync(StopFlowRequest request) {
        return this.stopFlowAsync(request, null);
    }

    @Override
    public Future<StopFlowResult> stopFlowAsync(StopFlowRequest request, final AsyncHandler<StopFlowRequest, StopFlowResult> asyncHandler) {
        final StopFlowRequest finalRequest = (StopFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopFlowResult>(){

            @Override
            public StopFlowResult call() throws Exception {
                StopFlowResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeStopFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateConnectorProfileResult> updateConnectorProfileAsync(UpdateConnectorProfileRequest request) {
        return this.updateConnectorProfileAsync(request, null);
    }

    @Override
    public Future<UpdateConnectorProfileResult> updateConnectorProfileAsync(UpdateConnectorProfileRequest request, final AsyncHandler<UpdateConnectorProfileRequest, UpdateConnectorProfileResult> asyncHandler) {
        final UpdateConnectorProfileRequest finalRequest = (UpdateConnectorProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateConnectorProfileResult>(){

            @Override
            public UpdateConnectorProfileResult call() throws Exception {
                UpdateConnectorProfileResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeUpdateConnectorProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowResult> updateFlowAsync(UpdateFlowRequest request) {
        return this.updateFlowAsync(request, null);
    }

    @Override
    public Future<UpdateFlowResult> updateFlowAsync(UpdateFlowRequest request, final AsyncHandler<UpdateFlowRequest, UpdateFlowResult> asyncHandler) {
        final UpdateFlowRequest finalRequest = (UpdateFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowResult>(){

            @Override
            public UpdateFlowResult call() throws Exception {
                UpdateFlowResult result = null;
                try {
                    result = AmazonAppflowAsyncClient.this.executeUpdateFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

