/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.ConnectorConfiguration;
import java.util.List;

@SdkInternalApi
public class ConnectorConfigurationMarshaller {
    private static final MarshallingInfo<Boolean> CANUSEASSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("canUseAsSource").build();
    private static final MarshallingInfo<Boolean> CANUSEASDESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("canUseAsDestination").build();
    private static final MarshallingInfo<List> SUPPORTEDDESTINATIONCONNECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedDestinationConnectors").build();
    private static final MarshallingInfo<List> SUPPORTEDSCHEDULINGFREQUENCIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedSchedulingFrequencies").build();
    private static final MarshallingInfo<Boolean> ISPRIVATELINKENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isPrivateLinkEnabled").build();
    private static final MarshallingInfo<Boolean> ISPRIVATELINKENDPOINTURLREQUIRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isPrivateLinkEndpointUrlRequired").build();
    private static final MarshallingInfo<List> SUPPORTEDTRIGGERTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedTriggerTypes").build();
    private static final MarshallingInfo<StructuredPojo> CONNECTORMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectorMetadata").build();
    private static final ConnectorConfigurationMarshaller instance = new ConnectorConfigurationMarshaller();

    public static ConnectorConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConnectorConfiguration connectorConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (connectorConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)connectorConfiguration.getCanUseAsSource(), CANUSEASSOURCE_BINDING);
            protocolMarshaller.marshall((Object)connectorConfiguration.getCanUseAsDestination(), CANUSEASDESTINATION_BINDING);
            protocolMarshaller.marshall(connectorConfiguration.getSupportedDestinationConnectors(), SUPPORTEDDESTINATIONCONNECTORS_BINDING);
            protocolMarshaller.marshall(connectorConfiguration.getSupportedSchedulingFrequencies(), SUPPORTEDSCHEDULINGFREQUENCIES_BINDING);
            protocolMarshaller.marshall((Object)connectorConfiguration.getIsPrivateLinkEnabled(), ISPRIVATELINKENABLED_BINDING);
            protocolMarshaller.marshall((Object)connectorConfiguration.getIsPrivateLinkEndpointUrlRequired(), ISPRIVATELINKENDPOINTURLREQUIRED_BINDING);
            protocolMarshaller.marshall(connectorConfiguration.getSupportedTriggerTypes(), SUPPORTEDTRIGGERTYPES_BINDING);
            protocolMarshaller.marshall((Object)connectorConfiguration.getConnectorMetadata(), CONNECTORMETADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

