/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appfabric.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appfabric.model.Credential;

@SdkInternalApi
public class CredentialMarshaller {
    private static final MarshallingInfo<StructuredPojo> OAUTH2CREDENTIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("oauth2Credential").build();
    private static final MarshallingInfo<StructuredPojo> APIKEYCREDENTIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiKeyCredential").build();
    private static final CredentialMarshaller instance = new CredentialMarshaller();

    public static CredentialMarshaller getInstance() {
        return instance;
    }

    public void marshall(Credential credential, ProtocolMarshaller protocolMarshaller) {
        if (credential == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)credential.getOauth2Credential(), OAUTH2CREDENTIAL_BINDING);
            protocolMarshaller.marshall((Object)credential.getApiKeyCredential(), APIKEYCREDENTIAL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

