/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appfabric;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.appfabric.AWSAppFabricAsync;
import com.amazonaws.services.appfabric.AWSAppFabricAsyncClientBuilder;
import com.amazonaws.services.appfabric.AWSAppFabricClient;
import com.amazonaws.services.appfabric.model.BatchGetUserAccessTasksRequest;
import com.amazonaws.services.appfabric.model.BatchGetUserAccessTasksResult;
import com.amazonaws.services.appfabric.model.ConnectAppAuthorizationRequest;
import com.amazonaws.services.appfabric.model.ConnectAppAuthorizationResult;
import com.amazonaws.services.appfabric.model.CreateAppAuthorizationRequest;
import com.amazonaws.services.appfabric.model.CreateAppAuthorizationResult;
import com.amazonaws.services.appfabric.model.CreateAppBundleRequest;
import com.amazonaws.services.appfabric.model.CreateAppBundleResult;
import com.amazonaws.services.appfabric.model.CreateIngestionDestinationRequest;
import com.amazonaws.services.appfabric.model.CreateIngestionDestinationResult;
import com.amazonaws.services.appfabric.model.CreateIngestionRequest;
import com.amazonaws.services.appfabric.model.CreateIngestionResult;
import com.amazonaws.services.appfabric.model.DeleteAppAuthorizationRequest;
import com.amazonaws.services.appfabric.model.DeleteAppAuthorizationResult;
import com.amazonaws.services.appfabric.model.DeleteAppBundleRequest;
import com.amazonaws.services.appfabric.model.DeleteAppBundleResult;
import com.amazonaws.services.appfabric.model.DeleteIngestionDestinationRequest;
import com.amazonaws.services.appfabric.model.DeleteIngestionDestinationResult;
import com.amazonaws.services.appfabric.model.DeleteIngestionRequest;
import com.amazonaws.services.appfabric.model.DeleteIngestionResult;
import com.amazonaws.services.appfabric.model.GetAppAuthorizationRequest;
import com.amazonaws.services.appfabric.model.GetAppAuthorizationResult;
import com.amazonaws.services.appfabric.model.GetAppBundleRequest;
import com.amazonaws.services.appfabric.model.GetAppBundleResult;
import com.amazonaws.services.appfabric.model.GetIngestionDestinationRequest;
import com.amazonaws.services.appfabric.model.GetIngestionDestinationResult;
import com.amazonaws.services.appfabric.model.GetIngestionRequest;
import com.amazonaws.services.appfabric.model.GetIngestionResult;
import com.amazonaws.services.appfabric.model.ListAppAuthorizationsRequest;
import com.amazonaws.services.appfabric.model.ListAppAuthorizationsResult;
import com.amazonaws.services.appfabric.model.ListAppBundlesRequest;
import com.amazonaws.services.appfabric.model.ListAppBundlesResult;
import com.amazonaws.services.appfabric.model.ListIngestionDestinationsRequest;
import com.amazonaws.services.appfabric.model.ListIngestionDestinationsResult;
import com.amazonaws.services.appfabric.model.ListIngestionsRequest;
import com.amazonaws.services.appfabric.model.ListIngestionsResult;
import com.amazonaws.services.appfabric.model.ListTagsForResourceRequest;
import com.amazonaws.services.appfabric.model.ListTagsForResourceResult;
import com.amazonaws.services.appfabric.model.StartIngestionRequest;
import com.amazonaws.services.appfabric.model.StartIngestionResult;
import com.amazonaws.services.appfabric.model.StartUserAccessTasksRequest;
import com.amazonaws.services.appfabric.model.StartUserAccessTasksResult;
import com.amazonaws.services.appfabric.model.StopIngestionRequest;
import com.amazonaws.services.appfabric.model.StopIngestionResult;
import com.amazonaws.services.appfabric.model.TagResourceRequest;
import com.amazonaws.services.appfabric.model.TagResourceResult;
import com.amazonaws.services.appfabric.model.UntagResourceRequest;
import com.amazonaws.services.appfabric.model.UntagResourceResult;
import com.amazonaws.services.appfabric.model.UpdateAppAuthorizationRequest;
import com.amazonaws.services.appfabric.model.UpdateAppAuthorizationResult;
import com.amazonaws.services.appfabric.model.UpdateIngestionDestinationRequest;
import com.amazonaws.services.appfabric.model.UpdateIngestionDestinationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSAppFabricAsyncClient
extends AWSAppFabricClient
implements AWSAppFabricAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSAppFabricAsyncClientBuilder asyncBuilder() {
        return AWSAppFabricAsyncClientBuilder.standard();
    }

    AWSAppFabricAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSAppFabricAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetUserAccessTasksResult> batchGetUserAccessTasksAsync(BatchGetUserAccessTasksRequest request) {
        return this.batchGetUserAccessTasksAsync(request, null);
    }

    @Override
    public Future<BatchGetUserAccessTasksResult> batchGetUserAccessTasksAsync(BatchGetUserAccessTasksRequest request, final AsyncHandler<BatchGetUserAccessTasksRequest, BatchGetUserAccessTasksResult> asyncHandler) {
        final BatchGetUserAccessTasksRequest finalRequest = (BatchGetUserAccessTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetUserAccessTasksResult>(){

            @Override
            public BatchGetUserAccessTasksResult call() throws Exception {
                BatchGetUserAccessTasksResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeBatchGetUserAccessTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConnectAppAuthorizationResult> connectAppAuthorizationAsync(ConnectAppAuthorizationRequest request) {
        return this.connectAppAuthorizationAsync(request, null);
    }

    @Override
    public Future<ConnectAppAuthorizationResult> connectAppAuthorizationAsync(ConnectAppAuthorizationRequest request, final AsyncHandler<ConnectAppAuthorizationRequest, ConnectAppAuthorizationResult> asyncHandler) {
        final ConnectAppAuthorizationRequest finalRequest = (ConnectAppAuthorizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ConnectAppAuthorizationResult>(){

            @Override
            public ConnectAppAuthorizationResult call() throws Exception {
                ConnectAppAuthorizationResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeConnectAppAuthorization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAppAuthorizationResult> createAppAuthorizationAsync(CreateAppAuthorizationRequest request) {
        return this.createAppAuthorizationAsync(request, null);
    }

    @Override
    public Future<CreateAppAuthorizationResult> createAppAuthorizationAsync(CreateAppAuthorizationRequest request, final AsyncHandler<CreateAppAuthorizationRequest, CreateAppAuthorizationResult> asyncHandler) {
        final CreateAppAuthorizationRequest finalRequest = (CreateAppAuthorizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAppAuthorizationResult>(){

            @Override
            public CreateAppAuthorizationResult call() throws Exception {
                CreateAppAuthorizationResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeCreateAppAuthorization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAppBundleResult> createAppBundleAsync(CreateAppBundleRequest request) {
        return this.createAppBundleAsync(request, null);
    }

    @Override
    public Future<CreateAppBundleResult> createAppBundleAsync(CreateAppBundleRequest request, final AsyncHandler<CreateAppBundleRequest, CreateAppBundleResult> asyncHandler) {
        final CreateAppBundleRequest finalRequest = (CreateAppBundleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAppBundleResult>(){

            @Override
            public CreateAppBundleResult call() throws Exception {
                CreateAppBundleResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeCreateAppBundle(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateIngestionResult> createIngestionAsync(CreateIngestionRequest request) {
        return this.createIngestionAsync(request, null);
    }

    @Override
    public Future<CreateIngestionResult> createIngestionAsync(CreateIngestionRequest request, final AsyncHandler<CreateIngestionRequest, CreateIngestionResult> asyncHandler) {
        final CreateIngestionRequest finalRequest = (CreateIngestionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateIngestionResult>(){

            @Override
            public CreateIngestionResult call() throws Exception {
                CreateIngestionResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeCreateIngestion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateIngestionDestinationResult> createIngestionDestinationAsync(CreateIngestionDestinationRequest request) {
        return this.createIngestionDestinationAsync(request, null);
    }

    @Override
    public Future<CreateIngestionDestinationResult> createIngestionDestinationAsync(CreateIngestionDestinationRequest request, final AsyncHandler<CreateIngestionDestinationRequest, CreateIngestionDestinationResult> asyncHandler) {
        final CreateIngestionDestinationRequest finalRequest = (CreateIngestionDestinationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateIngestionDestinationResult>(){

            @Override
            public CreateIngestionDestinationResult call() throws Exception {
                CreateIngestionDestinationResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeCreateIngestionDestination(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAppAuthorizationResult> deleteAppAuthorizationAsync(DeleteAppAuthorizationRequest request) {
        return this.deleteAppAuthorizationAsync(request, null);
    }

    @Override
    public Future<DeleteAppAuthorizationResult> deleteAppAuthorizationAsync(DeleteAppAuthorizationRequest request, final AsyncHandler<DeleteAppAuthorizationRequest, DeleteAppAuthorizationResult> asyncHandler) {
        final DeleteAppAuthorizationRequest finalRequest = (DeleteAppAuthorizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAppAuthorizationResult>(){

            @Override
            public DeleteAppAuthorizationResult call() throws Exception {
                DeleteAppAuthorizationResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeDeleteAppAuthorization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAppBundleResult> deleteAppBundleAsync(DeleteAppBundleRequest request) {
        return this.deleteAppBundleAsync(request, null);
    }

    @Override
    public Future<DeleteAppBundleResult> deleteAppBundleAsync(DeleteAppBundleRequest request, final AsyncHandler<DeleteAppBundleRequest, DeleteAppBundleResult> asyncHandler) {
        final DeleteAppBundleRequest finalRequest = (DeleteAppBundleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAppBundleResult>(){

            @Override
            public DeleteAppBundleResult call() throws Exception {
                DeleteAppBundleResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeDeleteAppBundle(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteIngestionResult> deleteIngestionAsync(DeleteIngestionRequest request) {
        return this.deleteIngestionAsync(request, null);
    }

    @Override
    public Future<DeleteIngestionResult> deleteIngestionAsync(DeleteIngestionRequest request, final AsyncHandler<DeleteIngestionRequest, DeleteIngestionResult> asyncHandler) {
        final DeleteIngestionRequest finalRequest = (DeleteIngestionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteIngestionResult>(){

            @Override
            public DeleteIngestionResult call() throws Exception {
                DeleteIngestionResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeDeleteIngestion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteIngestionDestinationResult> deleteIngestionDestinationAsync(DeleteIngestionDestinationRequest request) {
        return this.deleteIngestionDestinationAsync(request, null);
    }

    @Override
    public Future<DeleteIngestionDestinationResult> deleteIngestionDestinationAsync(DeleteIngestionDestinationRequest request, final AsyncHandler<DeleteIngestionDestinationRequest, DeleteIngestionDestinationResult> asyncHandler) {
        final DeleteIngestionDestinationRequest finalRequest = (DeleteIngestionDestinationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteIngestionDestinationResult>(){

            @Override
            public DeleteIngestionDestinationResult call() throws Exception {
                DeleteIngestionDestinationResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeDeleteIngestionDestination(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAppAuthorizationResult> getAppAuthorizationAsync(GetAppAuthorizationRequest request) {
        return this.getAppAuthorizationAsync(request, null);
    }

    @Override
    public Future<GetAppAuthorizationResult> getAppAuthorizationAsync(GetAppAuthorizationRequest request, final AsyncHandler<GetAppAuthorizationRequest, GetAppAuthorizationResult> asyncHandler) {
        final GetAppAuthorizationRequest finalRequest = (GetAppAuthorizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAppAuthorizationResult>(){

            @Override
            public GetAppAuthorizationResult call() throws Exception {
                GetAppAuthorizationResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeGetAppAuthorization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAppBundleResult> getAppBundleAsync(GetAppBundleRequest request) {
        return this.getAppBundleAsync(request, null);
    }

    @Override
    public Future<GetAppBundleResult> getAppBundleAsync(GetAppBundleRequest request, final AsyncHandler<GetAppBundleRequest, GetAppBundleResult> asyncHandler) {
        final GetAppBundleRequest finalRequest = (GetAppBundleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAppBundleResult>(){

            @Override
            public GetAppBundleResult call() throws Exception {
                GetAppBundleResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeGetAppBundle(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetIngestionResult> getIngestionAsync(GetIngestionRequest request) {
        return this.getIngestionAsync(request, null);
    }

    @Override
    public Future<GetIngestionResult> getIngestionAsync(GetIngestionRequest request, final AsyncHandler<GetIngestionRequest, GetIngestionResult> asyncHandler) {
        final GetIngestionRequest finalRequest = (GetIngestionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetIngestionResult>(){

            @Override
            public GetIngestionResult call() throws Exception {
                GetIngestionResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeGetIngestion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetIngestionDestinationResult> getIngestionDestinationAsync(GetIngestionDestinationRequest request) {
        return this.getIngestionDestinationAsync(request, null);
    }

    @Override
    public Future<GetIngestionDestinationResult> getIngestionDestinationAsync(GetIngestionDestinationRequest request, final AsyncHandler<GetIngestionDestinationRequest, GetIngestionDestinationResult> asyncHandler) {
        final GetIngestionDestinationRequest finalRequest = (GetIngestionDestinationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetIngestionDestinationResult>(){

            @Override
            public GetIngestionDestinationResult call() throws Exception {
                GetIngestionDestinationResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeGetIngestionDestination(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAppAuthorizationsResult> listAppAuthorizationsAsync(ListAppAuthorizationsRequest request) {
        return this.listAppAuthorizationsAsync(request, null);
    }

    @Override
    public Future<ListAppAuthorizationsResult> listAppAuthorizationsAsync(ListAppAuthorizationsRequest request, final AsyncHandler<ListAppAuthorizationsRequest, ListAppAuthorizationsResult> asyncHandler) {
        final ListAppAuthorizationsRequest finalRequest = (ListAppAuthorizationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAppAuthorizationsResult>(){

            @Override
            public ListAppAuthorizationsResult call() throws Exception {
                ListAppAuthorizationsResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeListAppAuthorizations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAppBundlesResult> listAppBundlesAsync(ListAppBundlesRequest request) {
        return this.listAppBundlesAsync(request, null);
    }

    @Override
    public Future<ListAppBundlesResult> listAppBundlesAsync(ListAppBundlesRequest request, final AsyncHandler<ListAppBundlesRequest, ListAppBundlesResult> asyncHandler) {
        final ListAppBundlesRequest finalRequest = (ListAppBundlesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAppBundlesResult>(){

            @Override
            public ListAppBundlesResult call() throws Exception {
                ListAppBundlesResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeListAppBundles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIngestionDestinationsResult> listIngestionDestinationsAsync(ListIngestionDestinationsRequest request) {
        return this.listIngestionDestinationsAsync(request, null);
    }

    @Override
    public Future<ListIngestionDestinationsResult> listIngestionDestinationsAsync(ListIngestionDestinationsRequest request, final AsyncHandler<ListIngestionDestinationsRequest, ListIngestionDestinationsResult> asyncHandler) {
        final ListIngestionDestinationsRequest finalRequest = (ListIngestionDestinationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListIngestionDestinationsResult>(){

            @Override
            public ListIngestionDestinationsResult call() throws Exception {
                ListIngestionDestinationsResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeListIngestionDestinations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIngestionsResult> listIngestionsAsync(ListIngestionsRequest request) {
        return this.listIngestionsAsync(request, null);
    }

    @Override
    public Future<ListIngestionsResult> listIngestionsAsync(ListIngestionsRequest request, final AsyncHandler<ListIngestionsRequest, ListIngestionsResult> asyncHandler) {
        final ListIngestionsRequest finalRequest = (ListIngestionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListIngestionsResult>(){

            @Override
            public ListIngestionsResult call() throws Exception {
                ListIngestionsResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeListIngestions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartIngestionResult> startIngestionAsync(StartIngestionRequest request) {
        return this.startIngestionAsync(request, null);
    }

    @Override
    public Future<StartIngestionResult> startIngestionAsync(StartIngestionRequest request, final AsyncHandler<StartIngestionRequest, StartIngestionResult> asyncHandler) {
        final StartIngestionRequest finalRequest = (StartIngestionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartIngestionResult>(){

            @Override
            public StartIngestionResult call() throws Exception {
                StartIngestionResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeStartIngestion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartUserAccessTasksResult> startUserAccessTasksAsync(StartUserAccessTasksRequest request) {
        return this.startUserAccessTasksAsync(request, null);
    }

    @Override
    public Future<StartUserAccessTasksResult> startUserAccessTasksAsync(StartUserAccessTasksRequest request, final AsyncHandler<StartUserAccessTasksRequest, StartUserAccessTasksResult> asyncHandler) {
        final StartUserAccessTasksRequest finalRequest = (StartUserAccessTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartUserAccessTasksResult>(){

            @Override
            public StartUserAccessTasksResult call() throws Exception {
                StartUserAccessTasksResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeStartUserAccessTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopIngestionResult> stopIngestionAsync(StopIngestionRequest request) {
        return this.stopIngestionAsync(request, null);
    }

    @Override
    public Future<StopIngestionResult> stopIngestionAsync(StopIngestionRequest request, final AsyncHandler<StopIngestionRequest, StopIngestionResult> asyncHandler) {
        final StopIngestionRequest finalRequest = (StopIngestionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopIngestionResult>(){

            @Override
            public StopIngestionResult call() throws Exception {
                StopIngestionResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeStopIngestion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAppAuthorizationResult> updateAppAuthorizationAsync(UpdateAppAuthorizationRequest request) {
        return this.updateAppAuthorizationAsync(request, null);
    }

    @Override
    public Future<UpdateAppAuthorizationResult> updateAppAuthorizationAsync(UpdateAppAuthorizationRequest request, final AsyncHandler<UpdateAppAuthorizationRequest, UpdateAppAuthorizationResult> asyncHandler) {
        final UpdateAppAuthorizationRequest finalRequest = (UpdateAppAuthorizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAppAuthorizationResult>(){

            @Override
            public UpdateAppAuthorizationResult call() throws Exception {
                UpdateAppAuthorizationResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeUpdateAppAuthorization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateIngestionDestinationResult> updateIngestionDestinationAsync(UpdateIngestionDestinationRequest request) {
        return this.updateIngestionDestinationAsync(request, null);
    }

    @Override
    public Future<UpdateIngestionDestinationResult> updateIngestionDestinationAsync(UpdateIngestionDestinationRequest request, final AsyncHandler<UpdateIngestionDestinationRequest, UpdateIngestionDestinationResult> asyncHandler) {
        final UpdateIngestionDestinationRequest finalRequest = (UpdateIngestionDestinationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateIngestionDestinationResult>(){

            @Override
            public UpdateIngestionDestinationResult call() throws Exception {
                UpdateIngestionDestinationResult result = null;
                try {
                    result = AWSAppFabricAsyncClient.this.executeUpdateIngestionDestination(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

