/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appfabric.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appfabric.model.Oauth2Credential;

@SdkInternalApi
public class Oauth2CredentialMarshaller {
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientId").build();
    private static final MarshallingInfo<String> CLIENTSECRET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientSecret").build();
    private static final Oauth2CredentialMarshaller instance = new Oauth2CredentialMarshaller();

    public static Oauth2CredentialMarshaller getInstance() {
        return instance;
    }

    public void marshall(Oauth2Credential oauth2Credential, ProtocolMarshaller protocolMarshaller) {
        if (oauth2Credential == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)oauth2Credential.getClientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)oauth2Credential.getClientSecret(), CLIENTSECRET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

