/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appconfigdata;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.appconfigdata.AWSAppConfigDataAsync;
import com.amazonaws.services.appconfigdata.AWSAppConfigDataAsyncClientBuilder;
import com.amazonaws.services.appconfigdata.AWSAppConfigDataClient;
import com.amazonaws.services.appconfigdata.model.GetLatestConfigurationRequest;
import com.amazonaws.services.appconfigdata.model.GetLatestConfigurationResult;
import com.amazonaws.services.appconfigdata.model.StartConfigurationSessionRequest;
import com.amazonaws.services.appconfigdata.model.StartConfigurationSessionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSAppConfigDataAsyncClient
extends AWSAppConfigDataClient
implements AWSAppConfigDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSAppConfigDataAsyncClientBuilder asyncBuilder() {
        return AWSAppConfigDataAsyncClientBuilder.standard();
    }

    AWSAppConfigDataAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSAppConfigDataAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetLatestConfigurationResult> getLatestConfigurationAsync(GetLatestConfigurationRequest request) {
        return this.getLatestConfigurationAsync(request, null);
    }

    @Override
    public Future<GetLatestConfigurationResult> getLatestConfigurationAsync(GetLatestConfigurationRequest request, final AsyncHandler<GetLatestConfigurationRequest, GetLatestConfigurationResult> asyncHandler) {
        final GetLatestConfigurationRequest finalRequest = (GetLatestConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLatestConfigurationResult>(){

            @Override
            public GetLatestConfigurationResult call() throws Exception {
                GetLatestConfigurationResult result = null;
                try {
                    result = AWSAppConfigDataAsyncClient.this.executeGetLatestConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartConfigurationSessionResult> startConfigurationSessionAsync(StartConfigurationSessionRequest request) {
        return this.startConfigurationSessionAsync(request, null);
    }

    @Override
    public Future<StartConfigurationSessionResult> startConfigurationSessionAsync(StartConfigurationSessionRequest request, final AsyncHandler<StartConfigurationSessionRequest, StartConfigurationSessionResult> asyncHandler) {
        final StartConfigurationSessionRequest finalRequest = (StartConfigurationSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartConfigurationSessionResult>(){

            @Override
            public StartConfigurationSessionResult call() throws Exception {
                StartConfigurationSessionResult result = null;
                try {
                    result = AWSAppConfigDataAsyncClient.this.executeStartConfigurationSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

