/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appconfigdata.model;

import com.amazonaws.services.appconfigdata.model.AWSAppConfigDataException;
import com.amazonaws.services.appconfigdata.model.ResourceType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public class ResourceNotFoundException
extends AWSAppConfigDataException {
    private static final long serialVersionUID = 1L;
    private Map<String, String> referencedBy;
    private String resourceType;

    public ResourceNotFoundException(String message) {
        super(message);
    }

    @JsonProperty(value="ReferencedBy")
    public Map<String, String> getReferencedBy() {
        return this.referencedBy;
    }

    @JsonProperty(value="ReferencedBy")
    public void setReferencedBy(Map<String, String> referencedBy) {
        this.referencedBy = referencedBy;
    }

    public ResourceNotFoundException withReferencedBy(Map<String, String> referencedBy) {
        this.setReferencedBy(referencedBy);
        return this;
    }

    public ResourceNotFoundException addReferencedByEntry(String key, String value) {
        if (null == this.referencedBy) {
            this.referencedBy = new HashMap<String, String>();
        }
        if (this.referencedBy.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.referencedBy.put(key, value);
        return this;
    }

    public ResourceNotFoundException clearReferencedByEntries() {
        this.referencedBy = null;
        return this;
    }

    @JsonProperty(value="ResourceType")
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @JsonProperty(value="ResourceType")
    public String getResourceType() {
        return this.resourceType;
    }

    public ResourceNotFoundException withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public ResourceNotFoundException withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }
}

