/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigatewayv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.apigatewayv2.model.JWTConfiguration;
import java.util.List;

@SdkInternalApi
public class JWTConfigurationMarshaller {
    private static final MarshallingInfo<List> AUDIENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audience").build();
    private static final MarshallingInfo<String> ISSUER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("issuer").build();
    private static final JWTConfigurationMarshaller instance = new JWTConfigurationMarshaller();

    public static JWTConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(JWTConfiguration jWTConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (jWTConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(jWTConfiguration.getAudience(), AUDIENCE_BINDING);
            protocolMarshaller.marshall((Object)jWTConfiguration.getIssuer(), ISSUER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

