/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifyuibuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplifyuibuilder.model.StorageAccessLevel;
import com.amazonaws.services.amplifyuibuilder.model.transform.FileUploaderFieldConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileUploaderFieldConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String accessLevel;
    private List<String> acceptedFileTypes;
    private Boolean showThumbnails;
    private Boolean isResumable;
    private Integer maxFileCount;
    private Integer maxSize;

    public void setAccessLevel(String accessLevel) {
        this.accessLevel = accessLevel;
    }

    public String getAccessLevel() {
        return this.accessLevel;
    }

    public FileUploaderFieldConfig withAccessLevel(String accessLevel) {
        this.setAccessLevel(accessLevel);
        return this;
    }

    public FileUploaderFieldConfig withAccessLevel(StorageAccessLevel accessLevel) {
        this.accessLevel = accessLevel.toString();
        return this;
    }

    public List<String> getAcceptedFileTypes() {
        return this.acceptedFileTypes;
    }

    public void setAcceptedFileTypes(Collection<String> acceptedFileTypes) {
        if (acceptedFileTypes == null) {
            this.acceptedFileTypes = null;
            return;
        }
        this.acceptedFileTypes = new ArrayList<String>(acceptedFileTypes);
    }

    public FileUploaderFieldConfig withAcceptedFileTypes(String ... acceptedFileTypes) {
        if (this.acceptedFileTypes == null) {
            this.setAcceptedFileTypes(new ArrayList<String>(acceptedFileTypes.length));
        }
        for (String ele : acceptedFileTypes) {
            this.acceptedFileTypes.add(ele);
        }
        return this;
    }

    public FileUploaderFieldConfig withAcceptedFileTypes(Collection<String> acceptedFileTypes) {
        this.setAcceptedFileTypes(acceptedFileTypes);
        return this;
    }

    public void setShowThumbnails(Boolean showThumbnails) {
        this.showThumbnails = showThumbnails;
    }

    public Boolean getShowThumbnails() {
        return this.showThumbnails;
    }

    public FileUploaderFieldConfig withShowThumbnails(Boolean showThumbnails) {
        this.setShowThumbnails(showThumbnails);
        return this;
    }

    public Boolean isShowThumbnails() {
        return this.showThumbnails;
    }

    public void setIsResumable(Boolean isResumable) {
        this.isResumable = isResumable;
    }

    public Boolean getIsResumable() {
        return this.isResumable;
    }

    public FileUploaderFieldConfig withIsResumable(Boolean isResumable) {
        this.setIsResumable(isResumable);
        return this;
    }

    public Boolean isResumable() {
        return this.isResumable;
    }

    public void setMaxFileCount(Integer maxFileCount) {
        this.maxFileCount = maxFileCount;
    }

    public Integer getMaxFileCount() {
        return this.maxFileCount;
    }

    public FileUploaderFieldConfig withMaxFileCount(Integer maxFileCount) {
        this.setMaxFileCount(maxFileCount);
        return this;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public FileUploaderFieldConfig withMaxSize(Integer maxSize) {
        this.setMaxSize(maxSize);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessLevel() != null) {
            sb.append("AccessLevel: ").append(this.getAccessLevel()).append(",");
        }
        if (this.getAcceptedFileTypes() != null) {
            sb.append("AcceptedFileTypes: ").append(this.getAcceptedFileTypes()).append(",");
        }
        if (this.getShowThumbnails() != null) {
            sb.append("ShowThumbnails: ").append(this.getShowThumbnails()).append(",");
        }
        if (this.getIsResumable() != null) {
            sb.append("IsResumable: ").append(this.getIsResumable()).append(",");
        }
        if (this.getMaxFileCount() != null) {
            sb.append("MaxFileCount: ").append(this.getMaxFileCount()).append(",");
        }
        if (this.getMaxSize() != null) {
            sb.append("MaxSize: ").append(this.getMaxSize());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileUploaderFieldConfig)) {
            return false;
        }
        FileUploaderFieldConfig other = (FileUploaderFieldConfig)obj;
        if (other.getAccessLevel() == null ^ this.getAccessLevel() == null) {
            return false;
        }
        if (other.getAccessLevel() != null && !other.getAccessLevel().equals(this.getAccessLevel())) {
            return false;
        }
        if (other.getAcceptedFileTypes() == null ^ this.getAcceptedFileTypes() == null) {
            return false;
        }
        if (other.getAcceptedFileTypes() != null && !other.getAcceptedFileTypes().equals(this.getAcceptedFileTypes())) {
            return false;
        }
        if (other.getShowThumbnails() == null ^ this.getShowThumbnails() == null) {
            return false;
        }
        if (other.getShowThumbnails() != null && !other.getShowThumbnails().equals(this.getShowThumbnails())) {
            return false;
        }
        if (other.getIsResumable() == null ^ this.getIsResumable() == null) {
            return false;
        }
        if (other.getIsResumable() != null && !other.getIsResumable().equals(this.getIsResumable())) {
            return false;
        }
        if (other.getMaxFileCount() == null ^ this.getMaxFileCount() == null) {
            return false;
        }
        if (other.getMaxFileCount() != null && !other.getMaxFileCount().equals(this.getMaxFileCount())) {
            return false;
        }
        if (other.getMaxSize() == null ^ this.getMaxSize() == null) {
            return false;
        }
        return other.getMaxSize() == null || other.getMaxSize().equals(this.getMaxSize());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessLevel() == null ? 0 : this.getAccessLevel().hashCode());
        hashCode = 31 * hashCode + (this.getAcceptedFileTypes() == null ? 0 : this.getAcceptedFileTypes().hashCode());
        hashCode = 31 * hashCode + (this.getShowThumbnails() == null ? 0 : this.getShowThumbnails().hashCode());
        hashCode = 31 * hashCode + (this.getIsResumable() == null ? 0 : this.getIsResumable().hashCode());
        hashCode = 31 * hashCode + (this.getMaxFileCount() == null ? 0 : this.getMaxFileCount().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSize() == null ? 0 : this.getMaxSize().hashCode());
        return hashCode;
    }

    public FileUploaderFieldConfig clone() {
        try {
            return (FileUploaderFieldConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileUploaderFieldConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

