/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifyuibuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplifyuibuilder.model.ThemeValues;
import com.amazonaws.services.amplifyuibuilder.model.transform.ThemeValueMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ThemeValue
implements Serializable,
Cloneable,
StructuredPojo {
    private String value;
    private List<ThemeValues> children;

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public ThemeValue withValue(String value) {
        this.setValue(value);
        return this;
    }

    public List<ThemeValues> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<ThemeValues> children) {
        if (children == null) {
            this.children = null;
            return;
        }
        this.children = new ArrayList<ThemeValues>(children);
    }

    public ThemeValue withChildren(ThemeValues ... children) {
        if (this.children == null) {
            this.setChildren(new ArrayList<ThemeValues>(children.length));
        }
        for (ThemeValues ele : children) {
            this.children.add(ele);
        }
        return this;
    }

    public ThemeValue withChildren(Collection<ThemeValues> children) {
        this.setChildren(children);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getChildren() != null) {
            sb.append("Children: ").append(this.getChildren());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThemeValue)) {
            return false;
        }
        ThemeValue other = (ThemeValue)obj;
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getChildren() == null ^ this.getChildren() == null) {
            return false;
        }
        return other.getChildren() == null || other.getChildren().equals(this.getChildren());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getChildren() == null ? 0 : this.getChildren().hashCode());
        return hashCode;
    }

    public ThemeValue clone() {
        try {
            return (ThemeValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThemeValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

