/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifyuibuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplifyuibuilder.model.FieldConfig;
import com.amazonaws.services.amplifyuibuilder.model.FormActionType;
import com.amazonaws.services.amplifyuibuilder.model.FormCTA;
import com.amazonaws.services.amplifyuibuilder.model.FormDataTypeConfig;
import com.amazonaws.services.amplifyuibuilder.model.FormStyle;
import com.amazonaws.services.amplifyuibuilder.model.LabelDecorator;
import com.amazonaws.services.amplifyuibuilder.model.SectionalElement;
import com.amazonaws.services.amplifyuibuilder.model.transform.FormMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Form
implements Serializable,
Cloneable,
StructuredPojo {
    private String appId;
    private String environmentName;
    private String id;
    private String name;
    private String formActionType;
    private FormStyle style;
    private FormDataTypeConfig dataType;
    private Map<String, FieldConfig> fields;
    private Map<String, SectionalElement> sectionalElements;
    private String schemaVersion;
    private Map<String, String> tags;
    private FormCTA cta;
    private String labelDecorator;

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public Form withAppId(String appId) {
        this.setAppId(appId);
        return this;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public Form withEnvironmentName(String environmentName) {
        this.setEnvironmentName(environmentName);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Form withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Form withName(String name) {
        this.setName(name);
        return this;
    }

    public void setFormActionType(String formActionType) {
        this.formActionType = formActionType;
    }

    public String getFormActionType() {
        return this.formActionType;
    }

    public Form withFormActionType(String formActionType) {
        this.setFormActionType(formActionType);
        return this;
    }

    public Form withFormActionType(FormActionType formActionType) {
        this.formActionType = formActionType.toString();
        return this;
    }

    public void setStyle(FormStyle style) {
        this.style = style;
    }

    public FormStyle getStyle() {
        return this.style;
    }

    public Form withStyle(FormStyle style) {
        this.setStyle(style);
        return this;
    }

    public void setDataType(FormDataTypeConfig dataType) {
        this.dataType = dataType;
    }

    public FormDataTypeConfig getDataType() {
        return this.dataType;
    }

    public Form withDataType(FormDataTypeConfig dataType) {
        this.setDataType(dataType);
        return this;
    }

    public Map<String, FieldConfig> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, FieldConfig> fields) {
        this.fields = fields;
    }

    public Form withFields(Map<String, FieldConfig> fields) {
        this.setFields(fields);
        return this;
    }

    public Form addFieldsEntry(String key, FieldConfig value) {
        if (null == this.fields) {
            this.fields = new HashMap<String, FieldConfig>();
        }
        if (this.fields.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.fields.put(key, value);
        return this;
    }

    public Form clearFieldsEntries() {
        this.fields = null;
        return this;
    }

    public Map<String, SectionalElement> getSectionalElements() {
        return this.sectionalElements;
    }

    public void setSectionalElements(Map<String, SectionalElement> sectionalElements) {
        this.sectionalElements = sectionalElements;
    }

    public Form withSectionalElements(Map<String, SectionalElement> sectionalElements) {
        this.setSectionalElements(sectionalElements);
        return this;
    }

    public Form addSectionalElementsEntry(String key, SectionalElement value) {
        if (null == this.sectionalElements) {
            this.sectionalElements = new HashMap<String, SectionalElement>();
        }
        if (this.sectionalElements.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.sectionalElements.put(key, value);
        return this;
    }

    public Form clearSectionalElementsEntries() {
        this.sectionalElements = null;
        return this;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public Form withSchemaVersion(String schemaVersion) {
        this.setSchemaVersion(schemaVersion);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Form withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Form addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Form clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setCta(FormCTA cta) {
        this.cta = cta;
    }

    public FormCTA getCta() {
        return this.cta;
    }

    public Form withCta(FormCTA cta) {
        this.setCta(cta);
        return this;
    }

    public void setLabelDecorator(String labelDecorator) {
        this.labelDecorator = labelDecorator;
    }

    public String getLabelDecorator() {
        return this.labelDecorator;
    }

    public Form withLabelDecorator(String labelDecorator) {
        this.setLabelDecorator(labelDecorator);
        return this;
    }

    public Form withLabelDecorator(LabelDecorator labelDecorator) {
        this.labelDecorator = labelDecorator.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppId() != null) {
            sb.append("AppId: ").append(this.getAppId()).append(",");
        }
        if (this.getEnvironmentName() != null) {
            sb.append("EnvironmentName: ").append(this.getEnvironmentName()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getFormActionType() != null) {
            sb.append("FormActionType: ").append(this.getFormActionType()).append(",");
        }
        if (this.getStyle() != null) {
            sb.append("Style: ").append(this.getStyle()).append(",");
        }
        if (this.getDataType() != null) {
            sb.append("DataType: ").append(this.getDataType()).append(",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: ").append(this.getFields()).append(",");
        }
        if (this.getSectionalElements() != null) {
            sb.append("SectionalElements: ").append(this.getSectionalElements()).append(",");
        }
        if (this.getSchemaVersion() != null) {
            sb.append("SchemaVersion: ").append(this.getSchemaVersion()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCta() != null) {
            sb.append("Cta: ").append(this.getCta()).append(",");
        }
        if (this.getLabelDecorator() != null) {
            sb.append("LabelDecorator: ").append(this.getLabelDecorator());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Form)) {
            return false;
        }
        Form other = (Form)obj;
        if (other.getAppId() == null ^ this.getAppId() == null) {
            return false;
        }
        if (other.getAppId() != null && !other.getAppId().equals(this.getAppId())) {
            return false;
        }
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getFormActionType() == null ^ this.getFormActionType() == null) {
            return false;
        }
        if (other.getFormActionType() != null && !other.getFormActionType().equals(this.getFormActionType())) {
            return false;
        }
        if (other.getStyle() == null ^ this.getStyle() == null) {
            return false;
        }
        if (other.getStyle() != null && !other.getStyle().equals(this.getStyle())) {
            return false;
        }
        if (other.getDataType() == null ^ this.getDataType() == null) {
            return false;
        }
        if (other.getDataType() != null && !other.getDataType().equals(this.getDataType())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        if (other.getFields() != null && !other.getFields().equals(this.getFields())) {
            return false;
        }
        if (other.getSectionalElements() == null ^ this.getSectionalElements() == null) {
            return false;
        }
        if (other.getSectionalElements() != null && !other.getSectionalElements().equals(this.getSectionalElements())) {
            return false;
        }
        if (other.getSchemaVersion() == null ^ this.getSchemaVersion() == null) {
            return false;
        }
        if (other.getSchemaVersion() != null && !other.getSchemaVersion().equals(this.getSchemaVersion())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCta() == null ^ this.getCta() == null) {
            return false;
        }
        if (other.getCta() != null && !other.getCta().equals(this.getCta())) {
            return false;
        }
        if (other.getLabelDecorator() == null ^ this.getLabelDecorator() == null) {
            return false;
        }
        return other.getLabelDecorator() == null || other.getLabelDecorator().equals(this.getLabelDecorator());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppId() == null ? 0 : this.getAppId().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getFormActionType() == null ? 0 : this.getFormActionType().hashCode());
        hashCode = 31 * hashCode + (this.getStyle() == null ? 0 : this.getStyle().hashCode());
        hashCode = 31 * hashCode + (this.getDataType() == null ? 0 : this.getDataType().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        hashCode = 31 * hashCode + (this.getSectionalElements() == null ? 0 : this.getSectionalElements().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaVersion() == null ? 0 : this.getSchemaVersion().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCta() == null ? 0 : this.getCta().hashCode());
        hashCode = 31 * hashCode + (this.getLabelDecorator() == null ? 0 : this.getLabelDecorator().hashCode());
        return hashCode;
    }

    public Form clone() {
        try {
            return (Form)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FormMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

