/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifybackend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplifybackend.model.OAuthGrantType;
import com.amazonaws.services.amplifybackend.model.OAuthScopesElement;
import com.amazonaws.services.amplifybackend.model.SocialProviderSettings;
import com.amazonaws.services.amplifybackend.model.transform.CreateBackendAuthOAuthConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateBackendAuthOAuthConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String domainPrefix;
    private String oAuthGrantType;
    private List<String> oAuthScopes;
    private List<String> redirectSignInURIs;
    private List<String> redirectSignOutURIs;
    private SocialProviderSettings socialProviderSettings;

    public void setDomainPrefix(String domainPrefix) {
        this.domainPrefix = domainPrefix;
    }

    public String getDomainPrefix() {
        return this.domainPrefix;
    }

    public CreateBackendAuthOAuthConfig withDomainPrefix(String domainPrefix) {
        this.setDomainPrefix(domainPrefix);
        return this;
    }

    public void setOAuthGrantType(String oAuthGrantType) {
        this.oAuthGrantType = oAuthGrantType;
    }

    public String getOAuthGrantType() {
        return this.oAuthGrantType;
    }

    public CreateBackendAuthOAuthConfig withOAuthGrantType(String oAuthGrantType) {
        this.setOAuthGrantType(oAuthGrantType);
        return this;
    }

    public CreateBackendAuthOAuthConfig withOAuthGrantType(OAuthGrantType oAuthGrantType) {
        this.oAuthGrantType = oAuthGrantType.toString();
        return this;
    }

    public List<String> getOAuthScopes() {
        return this.oAuthScopes;
    }

    public void setOAuthScopes(Collection<String> oAuthScopes) {
        if (oAuthScopes == null) {
            this.oAuthScopes = null;
            return;
        }
        this.oAuthScopes = new ArrayList<String>(oAuthScopes);
    }

    public CreateBackendAuthOAuthConfig withOAuthScopes(String ... oAuthScopes) {
        if (this.oAuthScopes == null) {
            this.setOAuthScopes(new ArrayList<String>(oAuthScopes.length));
        }
        for (String ele : oAuthScopes) {
            this.oAuthScopes.add(ele);
        }
        return this;
    }

    public CreateBackendAuthOAuthConfig withOAuthScopes(Collection<String> oAuthScopes) {
        this.setOAuthScopes(oAuthScopes);
        return this;
    }

    public CreateBackendAuthOAuthConfig withOAuthScopes(OAuthScopesElement ... oAuthScopes) {
        ArrayList<String> oAuthScopesCopy = new ArrayList<String>(oAuthScopes.length);
        for (OAuthScopesElement value : oAuthScopes) {
            oAuthScopesCopy.add(value.toString());
        }
        if (this.getOAuthScopes() == null) {
            this.setOAuthScopes(oAuthScopesCopy);
        } else {
            this.getOAuthScopes().addAll(oAuthScopesCopy);
        }
        return this;
    }

    public List<String> getRedirectSignInURIs() {
        return this.redirectSignInURIs;
    }

    public void setRedirectSignInURIs(Collection<String> redirectSignInURIs) {
        if (redirectSignInURIs == null) {
            this.redirectSignInURIs = null;
            return;
        }
        this.redirectSignInURIs = new ArrayList<String>(redirectSignInURIs);
    }

    public CreateBackendAuthOAuthConfig withRedirectSignInURIs(String ... redirectSignInURIs) {
        if (this.redirectSignInURIs == null) {
            this.setRedirectSignInURIs(new ArrayList<String>(redirectSignInURIs.length));
        }
        for (String ele : redirectSignInURIs) {
            this.redirectSignInURIs.add(ele);
        }
        return this;
    }

    public CreateBackendAuthOAuthConfig withRedirectSignInURIs(Collection<String> redirectSignInURIs) {
        this.setRedirectSignInURIs(redirectSignInURIs);
        return this;
    }

    public List<String> getRedirectSignOutURIs() {
        return this.redirectSignOutURIs;
    }

    public void setRedirectSignOutURIs(Collection<String> redirectSignOutURIs) {
        if (redirectSignOutURIs == null) {
            this.redirectSignOutURIs = null;
            return;
        }
        this.redirectSignOutURIs = new ArrayList<String>(redirectSignOutURIs);
    }

    public CreateBackendAuthOAuthConfig withRedirectSignOutURIs(String ... redirectSignOutURIs) {
        if (this.redirectSignOutURIs == null) {
            this.setRedirectSignOutURIs(new ArrayList<String>(redirectSignOutURIs.length));
        }
        for (String ele : redirectSignOutURIs) {
            this.redirectSignOutURIs.add(ele);
        }
        return this;
    }

    public CreateBackendAuthOAuthConfig withRedirectSignOutURIs(Collection<String> redirectSignOutURIs) {
        this.setRedirectSignOutURIs(redirectSignOutURIs);
        return this;
    }

    public void setSocialProviderSettings(SocialProviderSettings socialProviderSettings) {
        this.socialProviderSettings = socialProviderSettings;
    }

    public SocialProviderSettings getSocialProviderSettings() {
        return this.socialProviderSettings;
    }

    public CreateBackendAuthOAuthConfig withSocialProviderSettings(SocialProviderSettings socialProviderSettings) {
        this.setSocialProviderSettings(socialProviderSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainPrefix() != null) {
            sb.append("DomainPrefix: ").append(this.getDomainPrefix()).append(",");
        }
        if (this.getOAuthGrantType() != null) {
            sb.append("OAuthGrantType: ").append(this.getOAuthGrantType()).append(",");
        }
        if (this.getOAuthScopes() != null) {
            sb.append("OAuthScopes: ").append(this.getOAuthScopes()).append(",");
        }
        if (this.getRedirectSignInURIs() != null) {
            sb.append("RedirectSignInURIs: ").append(this.getRedirectSignInURIs()).append(",");
        }
        if (this.getRedirectSignOutURIs() != null) {
            sb.append("RedirectSignOutURIs: ").append(this.getRedirectSignOutURIs()).append(",");
        }
        if (this.getSocialProviderSettings() != null) {
            sb.append("SocialProviderSettings: ").append(this.getSocialProviderSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendAuthOAuthConfig)) {
            return false;
        }
        CreateBackendAuthOAuthConfig other = (CreateBackendAuthOAuthConfig)obj;
        if (other.getDomainPrefix() == null ^ this.getDomainPrefix() == null) {
            return false;
        }
        if (other.getDomainPrefix() != null && !other.getDomainPrefix().equals(this.getDomainPrefix())) {
            return false;
        }
        if (other.getOAuthGrantType() == null ^ this.getOAuthGrantType() == null) {
            return false;
        }
        if (other.getOAuthGrantType() != null && !other.getOAuthGrantType().equals(this.getOAuthGrantType())) {
            return false;
        }
        if (other.getOAuthScopes() == null ^ this.getOAuthScopes() == null) {
            return false;
        }
        if (other.getOAuthScopes() != null && !other.getOAuthScopes().equals(this.getOAuthScopes())) {
            return false;
        }
        if (other.getRedirectSignInURIs() == null ^ this.getRedirectSignInURIs() == null) {
            return false;
        }
        if (other.getRedirectSignInURIs() != null && !other.getRedirectSignInURIs().equals(this.getRedirectSignInURIs())) {
            return false;
        }
        if (other.getRedirectSignOutURIs() == null ^ this.getRedirectSignOutURIs() == null) {
            return false;
        }
        if (other.getRedirectSignOutURIs() != null && !other.getRedirectSignOutURIs().equals(this.getRedirectSignOutURIs())) {
            return false;
        }
        if (other.getSocialProviderSettings() == null ^ this.getSocialProviderSettings() == null) {
            return false;
        }
        return other.getSocialProviderSettings() == null || other.getSocialProviderSettings().equals(this.getSocialProviderSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainPrefix() == null ? 0 : this.getDomainPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getOAuthGrantType() == null ? 0 : this.getOAuthGrantType().hashCode());
        hashCode = 31 * hashCode + (this.getOAuthScopes() == null ? 0 : this.getOAuthScopes().hashCode());
        hashCode = 31 * hashCode + (this.getRedirectSignInURIs() == null ? 0 : this.getRedirectSignInURIs().hashCode());
        hashCode = 31 * hashCode + (this.getRedirectSignOutURIs() == null ? 0 : this.getRedirectSignOutURIs().hashCode());
        hashCode = 31 * hashCode + (this.getSocialProviderSettings() == null ? 0 : this.getSocialProviderSettings().hashCode());
        return hashCode;
    }

    public CreateBackendAuthOAuthConfig clone() {
        try {
            return (CreateBackendAuthOAuthConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateBackendAuthOAuthConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

