/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplify.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.amplify.model.Artifact;

@SdkInternalApi
public class ArtifactMarshaller {
    private static final MarshallingInfo<String> ARTIFACTFILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifactFileName").build();
    private static final MarshallingInfo<String> ARTIFACTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifactId").build();
    private static final ArtifactMarshaller instance = new ArtifactMarshaller();

    public static ArtifactMarshaller getInstance() {
        return instance;
    }

    public void marshall(Artifact artifact, ProtocolMarshaller protocolMarshaller) {
        if (artifact == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)artifact.getArtifactFileName(), ARTIFACTFILENAME_BINDING);
            protocolMarshaller.marshall((Object)artifact.getArtifactId(), ARTIFACTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

