/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplify.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.amplify.model.Step;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class StepMarshaller {
    private static final MarshallingInfo<String> STEPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stepName").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> LOGURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logUrl").build();
    private static final MarshallingInfo<String> ARTIFACTSURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifactsUrl").build();
    private static final MarshallingInfo<String> TESTARTIFACTSURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("testArtifactsUrl").build();
    private static final MarshallingInfo<String> TESTCONFIGURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("testConfigUrl").build();
    private static final MarshallingInfo<Map> SCREENSHOTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("screenshots").build();
    private static final MarshallingInfo<String> STATUSREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusReason").build();
    private static final MarshallingInfo<String> CONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("context").build();
    private static final StepMarshaller instance = new StepMarshaller();

    public static StepMarshaller getInstance() {
        return instance;
    }

    public void marshall(Step step, ProtocolMarshaller protocolMarshaller) {
        if (step == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)step.getStepName(), STEPNAME_BINDING);
            protocolMarshaller.marshall((Object)step.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)step.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)step.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)step.getLogUrl(), LOGURL_BINDING);
            protocolMarshaller.marshall((Object)step.getArtifactsUrl(), ARTIFACTSURL_BINDING);
            protocolMarshaller.marshall((Object)step.getTestArtifactsUrl(), TESTARTIFACTSURL_BINDING);
            protocolMarshaller.marshall((Object)step.getTestConfigUrl(), TESTCONFIGURL_BINDING);
            protocolMarshaller.marshall(step.getScreenshots(), SCREENSHOTS_BINDING);
            protocolMarshaller.marshall((Object)step.getStatusReason(), STATUSREASON_BINDING);
            protocolMarshaller.marshall((Object)step.getContext(), CONTEXT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

