/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.alexaforbusiness.model.Content;
import java.util.List;

@SdkInternalApi
public class ContentMarshaller {
    private static final MarshallingInfo<List> TEXTLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextList").build();
    private static final MarshallingInfo<List> SSMLLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SsmlList").build();
    private static final MarshallingInfo<List> AUDIOLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AudioList").build();
    private static final ContentMarshaller instance = new ContentMarshaller();

    public static ContentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Content content, ProtocolMarshaller protocolMarshaller) {
        if (content == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(content.getTextList(), TEXTLIST_BINDING);
            protocolMarshaller.marshall(content.getSsmlList(), SSMLLIST_BINDING);
            protocolMarshaller.marshall(content.getAudioList(), AUDIOLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

