/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.alexaforbusiness.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RegisterAVSDevice" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RegisterAVSDeviceRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The client ID of the OEM used for code-based linking authorization on an AVS device.
     * </p>
     */
    private String clientId;
    /**
     * <p>
     * The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
     * Authorization Request component of the OAuth code-based linking specification.
     * </p>
     */
    private String userCode;
    /**
     * <p>
     * The product ID used to identify your AVS device during authorization.
     * </p>
     */
    private String productId;
    /**
     * <p>
     * The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
     * </p>
     */
    private String deviceSerialNumber;
    /**
     * <p>
     * The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
     * Developer Console.
     * </p>
     */
    private String amazonId;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the room with which to associate your AVS device.
     * </p>
     */
    private String roomArn;
    /**
     * <p>
     * The tags to be added to the specified resource. Do not provide system tags.
     * </p>
     */
    private java.util.List<Tag> tags;

    /**
     * <p>
     * The client ID of the OEM used for code-based linking authorization on an AVS device.
     * </p>
     * 
     * @param clientId
     *        The client ID of the OEM used for code-based linking authorization on an AVS device.
     */

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    /**
     * <p>
     * The client ID of the OEM used for code-based linking authorization on an AVS device.
     * </p>
     * 
     * @return The client ID of the OEM used for code-based linking authorization on an AVS device.
     */

    public String getClientId() {
        return this.clientId;
    }

    /**
     * <p>
     * The client ID of the OEM used for code-based linking authorization on an AVS device.
     * </p>
     * 
     * @param clientId
     *        The client ID of the OEM used for code-based linking authorization on an AVS device.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterAVSDeviceRequest withClientId(String clientId) {
        setClientId(clientId);
        return this;
    }

    /**
     * <p>
     * The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
     * Authorization Request component of the OAuth code-based linking specification.
     * </p>
     * 
     * @param userCode
     *        The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
     *        Authorization Request component of the OAuth code-based linking specification.
     */

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    /**
     * <p>
     * The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
     * Authorization Request component of the OAuth code-based linking specification.
     * </p>
     * 
     * @return The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
     *         Authorization Request component of the OAuth code-based linking specification.
     */

    public String getUserCode() {
        return this.userCode;
    }

    /**
     * <p>
     * The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
     * Authorization Request component of the OAuth code-based linking specification.
     * </p>
     * 
     * @param userCode
     *        The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
     *        Authorization Request component of the OAuth code-based linking specification.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterAVSDeviceRequest withUserCode(String userCode) {
        setUserCode(userCode);
        return this;
    }

    /**
     * <p>
     * The product ID used to identify your AVS device during authorization.
     * </p>
     * 
     * @param productId
     *        The product ID used to identify your AVS device during authorization.
     */

    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * <p>
     * The product ID used to identify your AVS device during authorization.
     * </p>
     * 
     * @return The product ID used to identify your AVS device during authorization.
     */

    public String getProductId() {
        return this.productId;
    }

    /**
     * <p>
     * The product ID used to identify your AVS device during authorization.
     * </p>
     * 
     * @param productId
     *        The product ID used to identify your AVS device during authorization.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterAVSDeviceRequest withProductId(String productId) {
        setProductId(productId);
        return this;
    }

    /**
     * <p>
     * The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
     * </p>
     * 
     * @param deviceSerialNumber
     *        The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
     */

    public void setDeviceSerialNumber(String deviceSerialNumber) {
        this.deviceSerialNumber = deviceSerialNumber;
    }

    /**
     * <p>
     * The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
     * </p>
     * 
     * @return The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
     */

    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    /**
     * <p>
     * The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
     * </p>
     * 
     * @param deviceSerialNumber
     *        The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterAVSDeviceRequest withDeviceSerialNumber(String deviceSerialNumber) {
        setDeviceSerialNumber(deviceSerialNumber);
        return this;
    }

    /**
     * <p>
     * The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
     * Developer Console.
     * </p>
     * 
     * @param amazonId
     *        The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
     *        Developer Console.
     */

    public void setAmazonId(String amazonId) {
        this.amazonId = amazonId;
    }

    /**
     * <p>
     * The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
     * Developer Console.
     * </p>
     * 
     * @return The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
     *         Developer Console.
     */

    public String getAmazonId() {
        return this.amazonId;
    }

    /**
     * <p>
     * The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
     * Developer Console.
     * </p>
     * 
     * @param amazonId
     *        The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
     *        Developer Console.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterAVSDeviceRequest withAmazonId(String amazonId) {
        setAmazonId(amazonId);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the room with which to associate your AVS device.
     * </p>
     * 
     * @param roomArn
     *        The Amazon Resource Name (ARN) of the room with which to associate your AVS device.
     */

    public void setRoomArn(String roomArn) {
        this.roomArn = roomArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the room with which to associate your AVS device.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the room with which to associate your AVS device.
     */

    public String getRoomArn() {
        return this.roomArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the room with which to associate your AVS device.
     * </p>
     * 
     * @param roomArn
     *        The Amazon Resource Name (ARN) of the room with which to associate your AVS device.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterAVSDeviceRequest withRoomArn(String roomArn) {
        setRoomArn(roomArn);
        return this;
    }

    /**
     * <p>
     * The tags to be added to the specified resource. Do not provide system tags.
     * </p>
     * 
     * @return The tags to be added to the specified resource. Do not provide system tags.
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * The tags to be added to the specified resource. Do not provide system tags.
     * </p>
     * 
     * @param tags
     *        The tags to be added to the specified resource. Do not provide system tags.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * The tags to be added to the specified resource. Do not provide system tags.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        The tags to be added to the specified resource. Do not provide system tags.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterAVSDeviceRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The tags to be added to the specified resource. Do not provide system tags.
     * </p>
     * 
     * @param tags
     *        The tags to be added to the specified resource. Do not provide system tags.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterAVSDeviceRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientId() != null)
            sb.append("ClientId: ").append(getClientId()).append(",");
        if (getUserCode() != null)
            sb.append("UserCode: ").append(getUserCode()).append(",");
        if (getProductId() != null)
            sb.append("ProductId: ").append(getProductId()).append(",");
        if (getDeviceSerialNumber() != null)
            sb.append("DeviceSerialNumber: ").append(getDeviceSerialNumber()).append(",");
        if (getAmazonId() != null)
            sb.append("AmazonId: ").append(getAmazonId()).append(",");
        if (getRoomArn() != null)
            sb.append("RoomArn: ").append(getRoomArn()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RegisterAVSDeviceRequest == false)
            return false;
        RegisterAVSDeviceRequest other = (RegisterAVSDeviceRequest) obj;
        if (other.getClientId() == null ^ this.getClientId() == null)
            return false;
        if (other.getClientId() != null && other.getClientId().equals(this.getClientId()) == false)
            return false;
        if (other.getUserCode() == null ^ this.getUserCode() == null)
            return false;
        if (other.getUserCode() != null && other.getUserCode().equals(this.getUserCode()) == false)
            return false;
        if (other.getProductId() == null ^ this.getProductId() == null)
            return false;
        if (other.getProductId() != null && other.getProductId().equals(this.getProductId()) == false)
            return false;
        if (other.getDeviceSerialNumber() == null ^ this.getDeviceSerialNumber() == null)
            return false;
        if (other.getDeviceSerialNumber() != null && other.getDeviceSerialNumber().equals(this.getDeviceSerialNumber()) == false)
            return false;
        if (other.getAmazonId() == null ^ this.getAmazonId() == null)
            return false;
        if (other.getAmazonId() != null && other.getAmazonId().equals(this.getAmazonId()) == false)
            return false;
        if (other.getRoomArn() == null ^ this.getRoomArn() == null)
            return false;
        if (other.getRoomArn() != null && other.getRoomArn().equals(this.getRoomArn()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClientId() == null) ? 0 : getClientId().hashCode());
        hashCode = prime * hashCode + ((getUserCode() == null) ? 0 : getUserCode().hashCode());
        hashCode = prime * hashCode + ((getProductId() == null) ? 0 : getProductId().hashCode());
        hashCode = prime * hashCode + ((getDeviceSerialNumber() == null) ? 0 : getDeviceSerialNumber().hashCode());
        hashCode = prime * hashCode + ((getAmazonId() == null) ? 0 : getAmazonId().hashCode());
        hashCode = prime * hashCode + ((getRoomArn() == null) ? 0 : getRoomArn().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public RegisterAVSDeviceRequest clone() {
        return (RegisterAVSDeviceRequest) super.clone();
    }

}
