/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.acmpca.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.acmpca.AWSACMPCA;
import com.amazonaws.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest;
import com.amazonaws.services.acmpca.model.GetCertificateAuthorityCsrRequest;
import com.amazonaws.services.acmpca.model.GetCertificateRequest;
import com.amazonaws.services.acmpca.waiters.AuditReportCreated;
import com.amazonaws.services.acmpca.waiters.CertificateAuthorityCSRCreated;
import com.amazonaws.services.acmpca.waiters.CertificateIssued;
import com.amazonaws.services.acmpca.waiters.DescribeCertificateAuthorityAuditReportFunction;
import com.amazonaws.services.acmpca.waiters.GetCertificateAuthorityCsrFunction;
import com.amazonaws.services.acmpca.waiters.GetCertificateFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;

public class AWSACMPCAWaiters {
    private final AWSACMPCA client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AWSACMPCAWaiters");

    @SdkInternalApi
    public AWSACMPCAWaiters(AWSACMPCA client) {
        this.client = client;
    }

    public Waiter<GetCertificateRequest> certificateIssued() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetCertificateFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new CertificateIssued.IsRequestInProgressExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeCertificateAuthorityAuditReportRequest> auditReportCreated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeCertificateAuthorityAuditReportFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new AuditReportCreated.IsSUCCESSMatcher(), new AuditReportCreated.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetCertificateAuthorityCsrRequest> certificateAuthorityCSRCreated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetCertificateAuthorityCsrFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new CertificateAuthorityCSRCreated.IsRequestInProgressExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

