/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.acmpca.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.acmpca.model.Extensions;
import java.util.List;

@SdkInternalApi
public class ExtensionsMarshaller {
    private static final MarshallingInfo<List> CERTIFICATEPOLICIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificatePolicies").build();
    private static final MarshallingInfo<List> EXTENDEDKEYUSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtendedKeyUsage").build();
    private static final MarshallingInfo<StructuredPojo> KEYUSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyUsage").build();
    private static final MarshallingInfo<List> SUBJECTALTERNATIVENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubjectAlternativeNames").build();
    private static final ExtensionsMarshaller instance = new ExtensionsMarshaller();

    public static ExtensionsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Extensions extensions, ProtocolMarshaller protocolMarshaller) {
        if (extensions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(extensions.getCertificatePolicies(), CERTIFICATEPOLICIES_BINDING);
            protocolMarshaller.marshall(extensions.getExtendedKeyUsage(), EXTENDEDKEYUSAGE_BINDING);
            protocolMarshaller.marshall((Object)extensions.getKeyUsage(), KEYUSAGE_BINDING);
            protocolMarshaller.marshall(extensions.getSubjectAlternativeNames(), SUBJECTALTERNATIVENAMES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

