/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.JmesPathSubExpression;
import com.amazonaws.jmespath.JmesPathVisitor;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.certificatemanager.model.DescribeCertificateResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class CertificateValidated {
    CertificateValidated() {
    }

    static class IsResourceNotFoundExceptionMatcher
    extends WaiterAcceptor<DescribeCertificateResult> {
        IsResourceNotFoundExceptionMatcher() {
        }

        public boolean matches(AmazonServiceException e) {
            return "ResourceNotFoundException".equals(e.getErrorCode());
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }
    }

    static class IsFAILEDMatcher
    extends WaiterAcceptor<DescribeCertificateResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFAILEDMatcher() {
        }

        public boolean matches(DescribeCertificateResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathExpression[]{new JmesPathField("Certificate"), new JmesPathField("Status")});
        }
    }

    static class IsPENDING_VALIDATIONMatcher
    extends WaiterAcceptor<DescribeCertificateResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsPENDING_VALIDATIONMatcher() {
        }

        public boolean matches(DescribeCertificateResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.RETRY;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"PENDING_VALIDATION\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathSubExpression(new JmesPathExpression[]{new JmesPathField("Certificate"), new JmesPathField("DomainValidationOptions")})), (JmesPathExpression)new JmesPathField("ValidationStatus"));
        }
    }

    static class IsSUCCESSMatcher
    extends WaiterAcceptor<DescribeCertificateResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsSUCCESSMatcher() {
        }

        public boolean matches(DescribeCertificateResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAll((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"SUCCESS\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathSubExpression(new JmesPathExpression[]{new JmesPathField("Certificate"), new JmesPathField("DomainValidationOptions")})), (JmesPathExpression)new JmesPathField("ValidationStatus"));
        }
    }
}

